package com.mediatek.mcs.net;

import android.util.Base64;
import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.toolbox.HttpHeaderParser;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.domain.McsResponse;
import com.mediatek.mcs.pref.McsUser;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Sign In request to get a new token & access_token.
 */
public class SignInRequest extends Request<JSONObject> {
  private McsResponse.SuccessListener<JSONObject> listener;
  private Map<String, String> params;

  public SignInRequest(int method, String url, Map<String, String> params,
      McsResponse.SuccessListener<JSONObject> listener, McsResponse.ErrorListener errorListener) {
    super(method, url, McsRequestHelper.transformErrorListener(errorListener));
    this.params = params;
    this.listener = listener;
  }

  public SignInRequest(int method, String url, Map<String, String> params,
      McsResponse.SuccessListener<JSONObject> listener) {
    this(method, url, params, listener, new RequestErrorListener());
  }

  public static Map<String, String> getSignInParams() {
    Map<String, String> params = new HashMap<>();
    try {
      params.put("client_id", Base64.encodeToString(
          (Mcs.MCS_APP_KEY + ":" + Mcs.MCS_APP_SECRET).getBytes("UTF-8"), Base64.DEFAULT));
    } catch (UnsupportedEncodingException e) {
      McsLog.e(e.toString());
    }
    return params;
  }

  public static Map<String, String> getSignInParams(String refreshToken) {
    Map<String, String> params = new HashMap<>();
    params.put("token", refreshToken);
    return params;
  }

  @Override protected Map<String, String> getParams() {
    return params;
  }

  @Override public Map<String, String> getHeaders() throws AuthFailureError {
    Map<String, String> params = new HashMap<>();
    params.put("Content-Type", "application/x-www-form-urlencoded");
    return params;
  }

  @Override protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
    try {
      String jsonString = new String(
          response.data, HttpHeaderParser.parseCharset(response.headers));
      return Response.success(new JSONObject(jsonString),
          HttpHeaderParser.parseCacheHeaders(response));
    } catch (UnsupportedEncodingException e) {
      return Response.error(new ParseError(e));
    } catch (JSONException je) {
      return Response.error(new ParseError(je));
    }
  }

  @Override protected void deliverResponse(JSONObject response) {
    listener.onSuccess(response);
  }
}
