package com.mediatek.mcs.net;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.mediatek.mcs.Mcs;

public class RequestManager extends Application {
  public static final String TAG = RequestManager.class.getSimpleName();
  private static RequestManager mInstance;
  private RequestQueue mRequestQueue;

  public static synchronized RequestManager getInstance() {
    if (mInstance == null) mInstance = new RequestManager();
    return mInstance;
  }

  public static void sendInBackground(Request request) {
    getInstance().addToRequestQueue(request, Mcs.getApplicationContext());
  }

  @Override public void onCreate() {
    super.onCreate();
    mInstance = this;
  }

  public RequestQueue getRequestQueue(Context ctx) {
    if (mRequestQueue == null) {
      mRequestQueue = Volley.newRequestQueue(ctx);
    }

    return mRequestQueue;
  }

  public <T> void addToRequestQueue(Request<T> req, String tag, Context ctx) {
    // set the default tag if tag is empty
    req.setTag(TextUtils.isEmpty(tag) ? TAG : tag);
    getRequestQueue(ctx).add(req);
  }

  public <T> void addToRequestQueue(Request<T> req, Context ctx) {
    req.setTag(TAG);
    getRequestQueue(ctx).add(req);
  }

  public void cancelPendingRequests(Object tag) {
    if (mRequestQueue != null) {
      mRequestQueue.cancelAll(tag);
    }
  }
}