package com.mediatek.mcs.net;

import com.mediatek.mcs.Utils.UIUtils;
import com.mediatek.mcs.domain.McsResponse;

/**
 * This is the default / basic error listener of every request used in mcs app.
 *
 * The access_token would be expired every 1 hour.
 * Thus use token to request for new access_token.
 */
public class RequestErrorListener implements McsResponse.ErrorListener {
  @Override public void onError(Exception error) {
    UIUtils.toast(RequestUtils.parseMcsNetworkError(error));
  }
}
