package com.mediatek.mcs.entity;

import com.mediatek.mcs.net.RequestApi;
import java.util.List;

public class ProductEntity extends McsEntity {
  private String prodId;
  private String name;
  private String description;
  private String chip;
  private List<DisplayConfigEntity> displayConfigs;
  private String version;
  private String privilege;

  private String createdByNickName;
  private Industry prodIndType;
  private Application prodAppType;
  private Image images;

  public String getCreatedByNickName() {
    return createdByNickName;
  }

  public Industry getProdIndType() {
    return prodIndType;
  }

  public Application getProdAppType() {
    return prodAppType;
  }

  public Image getImages() {
    return images;
  }

  public String getProdId() {
    return prodId;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public String getChip() {
    return chip;
  }

  public List<DisplayConfigEntity> getDisplayConfigs() {
    return displayConfigs;
  }

  public String getVersion() {
    return version;
  }

  public String getPrivilege() {
    return privilege;
  }

  public static class Industry {
    private Integer prodIndTypeId;
    private String name;

    public Integer getProdIndTypeId() {
      return prodIndTypeId;
    }

    public String getName() {
      return name;
    }
  }

  public static class Application {
    private Integer prodAppTypeId;
    private String name;

    public Integer getProdAppTypeId() {
      return prodAppTypeId;
    }

    public String getName() {
      return name;
    }
  }

  public static class Image {
    private boolean isMain;
    private String prodImgId;
    private String url;         // relative path, need getImageServerPrefix()
    private String description;

    public boolean isMain() {
      return isMain;
    }

    public String getProdImgId() {
      return prodImgId;
    }

    public String getUrl() {
      return RequestApi.getImageServerPrefix() + url;
    }

    public String getDescription() {
      return description;
    }
  }
}