/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth;

import com.mdsol.mauth.MAuthConfiguration;
import com.typesafe.config.Config;
import java.util.UUID;

public class SignerConfiguration
implements MAuthConfiguration {
    public static final String APP_SECTION_HEADER = "app";
    public static final String MAUTH_SECTION_HEADER = "mauth";
    public static final String APP_UUID_PATH = "app.uuid";
    public static final String APP_PRIVATE_KEY_PATH = "app.private_key";
    public static final String V2_ONLY_SIGN_REQUESTS = "mauth.v2_only_sign_requests";
    private final UUID appUUID;
    private final transient String privateKey;
    private boolean v2OnlySignRequests = false;

    public SignerConfiguration(Config config) {
        this(UUID.fromString(config.getString(APP_UUID_PATH)), config.getString(APP_PRIVATE_KEY_PATH), config.hasPath(V2_ONLY_SIGN_REQUESTS) || config.isEmpty() ? config.getBoolean(V2_ONLY_SIGN_REQUESTS) : false);
    }

    public SignerConfiguration(UUID uUID, String string) {
        this.validateNotNull(uUID, "Application UUID");
        this.validateNotBlank(string, "Application Private key");
        this.appUUID = uUID;
        this.privateKey = string;
    }

    public SignerConfiguration(UUID uUID, String string, boolean bl) {
        this.validateNotNull(uUID, "Application UUID");
        this.validateNotBlank(string, "Application Private key");
        this.appUUID = uUID;
        this.privateKey = string;
        this.v2OnlySignRequests = bl;
    }

    public UUID getAppUUID() {
        return this.appUUID;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public boolean isV2OnlySignRequests() {
        return this.v2OnlySignRequests;
    }
}

