/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth;

import com.mdsol.mauth.MAuthVersion;
import com.mdsol.mauth.util.MAuthHeadersHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class MAuthRequest {
    public static final String X_MWS_TIME_HEADER_NAME = "x-mws-time";
    public static final String X_MWS_AUTHENTICATION_HEADER_NAME = "x-mws-authentication";
    public static final String MCC_TIME_HEADER_NAME = "mcc-time";
    public static final String MCC_AUTHENTICATION_HEADER_NAME = "mcc-authentication";
    private static final String VALIDATION_EXCEPTION_MESSAGE_TEMPLATE = "%s cannot be null or empty.";
    private final UUID appUUID;
    private final String requestSignature;
    private byte[] messagePayload;
    private final String httpMethod;
    private final long requestTime;
    private final String resourcePath;
    private final String queryParameters;
    private final MAuthVersion mauthVersion;
    private String xmwsSignature = null;
    private String xmwsTime = null;
    private InputStream bodyInputStream = null;

    @Deprecated
    public MAuthRequest(String string, byte[] byArray, String string2, String string3, String string4) {
        this(string, byArray, string2, string3, string4, "");
    }

    public MAuthRequest(String string, byte[] byArray, String string2, String string3, String string4, String string5) {
        this(string, byArray, null, string2, string3, string4, string5);
    }

    public MAuthRequest(String string, InputStream inputStream, String string2, String string3, String string4, String string5) {
        this(string, null, inputStream, string2, string3, string4, string5);
    }

    private MAuthRequest(String string, byte[] byArray, InputStream inputStream, String string2, String string3, String string4, String string5) {
        this.validateNotBlank(string, "Authentication header value");
        this.validateNotBlank(string3, "Time header value");
        UUID uUID = MAuthHeadersHelper.getAppUUIDFromAuthenticationHeader(string);
        String string6 = MAuthHeadersHelper.getSignatureFromAuthenticationHeader(string);
        long l = MAuthHeadersHelper.getRequestTimeFromTimeHeader(string3);
        this.validateNotBlank(string2, "Http method");
        this.validateNotBlank(string4, "Resource path");
        this.validateRequestTime(l);
        if (string5 == null) {
            string5 = "";
        }
        this.appUUID = uUID;
        this.requestSignature = string6;
        this.httpMethod = string2;
        this.requestTime = l;
        this.resourcePath = string4;
        this.queryParameters = string5;
        this.mauthVersion = MAuthHeadersHelper.getMauthVersion(string);
        if (inputStream != null && byArray != null) {
            throw new IllegalArgumentException("Only one of bodyInputStream and messagePayload should be provided.");
        }
        if (byArray == null && inputStream == null) {
            byArray = new byte[]{};
        }
        if (byArray != null) {
            this.messagePayload = byArray;
            this.bodyInputStream = new ByteArrayInputStream(byArray);
        } else {
            this.messagePayload = null;
            this.bodyInputStream = inputStream;
        }
    }

    public UUID getAppUUID() {
        return this.appUUID;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public byte[] getMessagePayload() {
        if (this.messagePayload != null) {
            return Arrays.copyOf(this.messagePayload, this.messagePayload.length);
        }
        return null;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getQueryParameters() {
        return this.queryParameters;
    }

    public String getXmwsSignature() {
        return this.xmwsSignature;
    }

    public void setXmwsSignature(String string) {
        this.xmwsSignature = string;
    }

    public String getXmwsTime() {
        return this.xmwsTime;
    }

    public void setXmwsTime(String string) {
        this.xmwsTime = string;
    }

    public MAuthVersion getMauthVersion() {
        return this.mauthVersion;
    }

    public InputStream getBodyInputStream() {
        return this.bodyInputStream;
    }

    private void validateNotBlank(String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException(String.format(VALIDATION_EXCEPTION_MESSAGE_TEMPLATE, string2));
        }
    }

    private void validateRequestTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Request time cannot be negative or 0.");
        }
    }

    public static final class Builder {
        private String authenticationHeaderValue;
        private byte[] messagePayload;
        private String httpMethod;
        private String timeHeaderValue;
        private String resourcePath;
        private String queryParameters;
        private TreeMap<String, String> mauthHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        private InputStream bodyInputStream = null;

        public static Builder get() {
            return new Builder();
        }

        public Builder withAuthenticationHeaderValue(String string) {
            this.authenticationHeaderValue = string;
            return this;
        }

        public Builder withTimeHeaderValue(String string) {
            this.timeHeaderValue = string;
            return this;
        }

        public Builder withMessagePayload(byte[] byArray) {
            this.messagePayload = byArray;
            return this;
        }

        public Builder withHttpMethod(String string) {
            this.httpMethod = string;
            return this;
        }

        public Builder withResourcePath(String string) {
            this.resourcePath = string;
            return this;
        }

        public Builder withQueryParameters(String string) {
            this.queryParameters = string;
            return this;
        }

        public Builder withBodyInputStream(InputStream inputStream) {
            this.bodyInputStream = inputStream;
            return this;
        }

        public Builder withMauthHeaders(Map<String, String> map) {
            this.mauthHeaders.putAll(map);
            return this;
        }

        public MAuthRequest build() {
            MAuthRequest mAuthRequest;
            if (this.mauthHeaders != null && !this.mauthHeaders.isEmpty()) {
                if (this.mauthHeaders.get(MAuthRequest.MCC_AUTHENTICATION_HEADER_NAME) != null) {
                    this.authenticationHeaderValue = this.mauthHeaders.get(MAuthRequest.MCC_AUTHENTICATION_HEADER_NAME);
                    this.timeHeaderValue = this.mauthHeaders.get(MAuthRequest.MCC_TIME_HEADER_NAME);
                } else {
                    this.authenticationHeaderValue = this.mauthHeaders.get(MAuthRequest.X_MWS_AUTHENTICATION_HEADER_NAME);
                    this.timeHeaderValue = this.mauthHeaders.get(MAuthRequest.X_MWS_TIME_HEADER_NAME);
                }
            }
            if ((mAuthRequest = new MAuthRequest(this.authenticationHeaderValue, this.messagePayload, this.bodyInputStream, this.httpMethod, this.timeHeaderValue, this.resourcePath, this.queryParameters)).getMauthVersion().equals((Object)MAuthVersion.MWSV2)) {
                mAuthRequest.setXmwsSignature(this.mauthHeaders.get(MAuthRequest.X_MWS_AUTHENTICATION_HEADER_NAME));
                mAuthRequest.setXmwsTime(this.mauthHeaders.get(MAuthRequest.X_MWS_TIME_HEADER_NAME));
            }
            return mAuthRequest;
        }
    }
}

