/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth;

import com.mdsol.mauth.MAuthConfiguration;
import com.typesafe.config.Config;

public class AuthenticatorConfiguration
implements MAuthConfiguration {
    public static final String MAUTH_SECTION_HEADER = "mauth";
    public static final String BASE_URL_PATH = "mauth.base_url";
    public static final String REQUEST_URL_PATH = "mauth.request_url";
    public static final String TOKEN_URL_PATH = "mauth.token_url";
    public static final String TIME_TO_LIVE_SECONDS = "mauth.cache.time_to_live_seconds";
    public static final String V2_ONLY_AUTHENTICATE = "mauth.v2_only_authenticate";
    private final String baseUrl;
    private final String requestUrlPath;
    private final String securityTokensUrlPath;
    private final Long timeToLive;
    private final boolean v2OnlyAuthenticate;

    public AuthenticatorConfiguration(Config config) {
        this(config.getString(BASE_URL_PATH), config.getString(REQUEST_URL_PATH), config.getString(TOKEN_URL_PATH), config.getLong(TIME_TO_LIVE_SECONDS), config.getBoolean(V2_ONLY_AUTHENTICATE));
    }

    public AuthenticatorConfiguration(String string, String string2, String string3, Long l) {
        this(string, string2, string3, l, false);
    }

    public AuthenticatorConfiguration(String string, String string2, String string3, Long l, boolean bl) {
        this.validateNotBlank(string, "MAuth base url");
        this.validateNotBlank(string2, "MAuth request url path");
        this.validateNotBlank(string3, "MAuth Security tokens url path");
        this.baseUrl = string;
        this.requestUrlPath = string2;
        this.securityTokensUrlPath = string3;
        this.timeToLive = l;
        this.v2OnlyAuthenticate = bl;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public String getRequestUrlPath() {
        return this.requestUrlPath;
    }

    public String getSecurityTokensUrlPath() {
        return this.securityTokensUrlPath;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isV2OnlyAuthenticate() {
        return this.v2OnlyAuthenticate;
    }
}

