/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth;

import com.mdsol.mauth.Authenticator;
import com.mdsol.mauth.MAuthRequest;
import com.mdsol.mauth.MAuthVersion;
import com.mdsol.mauth.exception.MAuthValidationException;
import com.mdsol.mauth.util.CurrentEpochTimeProvider;
import com.mdsol.mauth.util.EpochTimeProvider;
import com.mdsol.mauth.util.MAuthSignatureHelper;
import com.mdsol.mauth.utils.ClientPublicKeyProvider;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Arrays;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(RequestAuthenticator.class);
    private final ClientPublicKeyProvider clientPublicKeyProvider;
    private final long requestValidationTimeoutSeconds;
    private final EpochTimeProvider epochTimeProvider;
    private final boolean v2OnlyAuthenticate;

    public RequestAuthenticator(ClientPublicKeyProvider clientPublicKeyProvider) {
        this(clientPublicKeyProvider, 10L);
    }

    public RequestAuthenticator(ClientPublicKeyProvider clientPublicKeyProvider, boolean bl) {
        this(clientPublicKeyProvider, 10L, bl);
    }

    public RequestAuthenticator(ClientPublicKeyProvider clientPublicKeyProvider, long l) {
        this(clientPublicKeyProvider, l, (EpochTimeProvider)new CurrentEpochTimeProvider());
    }

    public RequestAuthenticator(ClientPublicKeyProvider clientPublicKeyProvider, long l, boolean bl) {
        this(clientPublicKeyProvider, l, (EpochTimeProvider)new CurrentEpochTimeProvider(), bl);
    }

    public RequestAuthenticator(ClientPublicKeyProvider clientPublicKeyProvider, long l, EpochTimeProvider epochTimeProvider) {
        this(clientPublicKeyProvider, l, epochTimeProvider, false);
    }

    public RequestAuthenticator(ClientPublicKeyProvider clientPublicKeyProvider, long l, EpochTimeProvider epochTimeProvider, boolean bl) {
        this.clientPublicKeyProvider = clientPublicKeyProvider;
        this.requestValidationTimeoutSeconds = l;
        this.epochTimeProvider = epochTimeProvider;
        this.v2OnlyAuthenticate = bl;
    }

    @Override
    public boolean authenticate(MAuthRequest mAuthRequest) {
        if (!this.validateTime(mAuthRequest.getRequestTime())) {
            String string = "MAuth request validation failed because request time was older than" + this.requestValidationTimeoutSeconds + "s";
            logger.error(string);
            throw new MAuthValidationException(string);
        }
        if (this.v2OnlyAuthenticate && !mAuthRequest.getMauthVersion().equals((Object)MAuthVersion.MWSV2)) {
            logger.error("The service requires mAuth v2 authentication headers.");
            throw new MAuthValidationException("The service requires mAuth v2 authentication headers.");
        }
        PublicKey publicKey = this.clientPublicKeyProvider.getPublicKey(mAuthRequest.getAppUUID());
        if (mAuthRequest.getMauthVersion().equals((Object)MAuthVersion.MWSV2)) {
            boolean bl = this.validateSignatureV2(mAuthRequest, publicKey);
            if (this.v2OnlyAuthenticate) {
                return bl;
            }
            if (bl) {
                return bl;
            }
            return this.fallbackValidateSignatureV1(mAuthRequest, publicKey);
        }
        return this.validateSignatureV1(mAuthRequest, publicKey);
    }

    private boolean validateTime(long l) {
        long l2 = this.epochTimeProvider.inSeconds();
        return l2 - l < this.requestValidationTimeoutSeconds;
    }

    private boolean validateSignatureV1(MAuthRequest mAuthRequest, PublicKey publicKey) {
        this.logAuthenticationRequest(mAuthRequest);
        byte[] byArray = MAuthSignatureHelper.decryptSignature((PublicKey)publicKey, (String)mAuthRequest.getRequestSignature());
        try {
            byte[] byArray2 = MAuthSignatureHelper.generateDigestedMessageV1((MAuthRequest)mAuthRequest).getBytes(StandardCharsets.UTF_8);
            return Arrays.equals(byArray2, byArray);
        }
        catch (Exception exception) {
            logger.error("MAuth request validation failed for V1", (Throwable)exception);
            throw new MAuthValidationException("MAuth request validation failed for V1", exception);
        }
    }

    private boolean validateSignatureV2(MAuthRequest mAuthRequest, PublicKey publicKey) {
        this.logAuthenticationRequest(mAuthRequest);
        String string = MAuthSignatureHelper.generateStringToSignV2((MAuthRequest)mAuthRequest);
        try {
            return MAuthSignatureHelper.verifyRSA((String)string, (String)mAuthRequest.getRequestSignature(), (PublicKey)publicKey);
        }
        catch (Exception exception) {
            logger.error("MAuth request validation failed for V2", (Throwable)exception);
            throw new MAuthValidationException("MAuth request validation failed for V2", exception);
        }
    }

    private boolean fallbackValidateSignatureV1(MAuthRequest mAuthRequest, PublicKey publicKey) {
        MAuthRequest mAuthRequest2;
        boolean bl = false;
        if (mAuthRequest.getMessagePayload() == null) {
            logger.warn("V1 authentication fallback is not available because the full request body is not available in memory.");
        } else if (mAuthRequest.getXmwsSignature() != null && mAuthRequest.getXmwsTime() != null && (bl = this.validateSignatureV1(mAuthRequest2 = new MAuthRequest(mAuthRequest.getXmwsSignature(), mAuthRequest.getMessagePayload(), mAuthRequest.getHttpMethod(), mAuthRequest.getXmwsTime(), mAuthRequest.getResourcePath(), mAuthRequest.getQueryParameters()), publicKey))) {
            logger.warn("Completed successful authentication attempt after fallback to V1");
        }
        return bl;
    }

    private void logAuthenticationRequest(MAuthRequest mAuthRequest) {
        logger.info(String.format("Mauth-client attempting to authenticate request from app with mauth app uuid %s using version %s.", mAuthRequest.getAppUUID(), mAuthRequest.getMauthVersion().getValue()));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

