/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.audioprocessing;

import fm.icelink.AecPipe;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.IAudioSource;
import fm.icelink.IMediaSource;
import fm.icelink.Log;
import fm.icelink.ManagedStopwatch;
import fm.icelink.MediaBuffer;
import fm.icelink.StringExtensions;
import fm.icelink.audioprocessing.Native;
import fm.icelink.pcm.Format;

public class AecProcessor
extends AecPipe {
    private int __millis = -1;
    private int __minimumTailLength;
    private Native __native;
    private int __tailLength = 80;
    private ManagedStopwatch __watch = new ManagedStopwatch();

    public AecProcessor(AudioFormat format) {
        this(format, 10);
    }

    public AecProcessor(IAudioSource microphone) {
        this((AudioFormat)microphone.getOutputFormat());
        super.addSource((IMediaSource)microphone);
    }

    public AecProcessor(AudioConfig config, int minimumTailLength) {
        this((AudioFormat)new Format(config), minimumTailLength);
    }

    public AecProcessor(AudioFormat format, int minimumTailLength) {
        super(format);
        this.__minimumTailLength = minimumTailLength;
        if (format.getClockRate() != 8000 && format.getClockRate() != 16000) {
            throw new RuntimeException(new Exception("AecProcessor can only handle clock rates of either 8000 or 16000."));
        }
        if (format.getChannelCount() != 1) {
            throw new RuntimeException(new Exception("AecProcessor can only handle single channel audio sources."));
        }
        this.__native = new Native(format.getClockRate(), format.getChannelCount());
        this.__watch.start();
    }

    public AecProcessor(AudioConfig config) {
        this((AudioFormat)new Format(config));
    }

    protected void doDestroy() {
        super.doDestroy();
        if (this.__native != null) {
            this.__native.destroy();
            this.__native = null;
        }
    }

    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        AudioBuffer buffer;
        if (80 == this.__tailLength && this.__millis >= 0) {
            this.__tailLength = this.__minimumTailLength;
            Log.info((String)StringExtensions.format((String)"AEC Tail length has been set to: {0}", (Object)this.__tailLength));
        }
        if ((buffer = this.__native.capture(frame, inputBuffer, (AudioFormat)super.getOutputFormat(), this.__tailLength)) != null) {
            frame.addBuffer((MediaBuffer)buffer);
            this.raiseFrame(frame);
            buffer.releaseBuffers();
        }
    }

    public String getLabel() {
        return "AEC Processor";
    }

    private boolean hasData(AudioBuffer buffer) {
        for (int i = buffer.getDataBuffer().getIndex(); i < buffer.getDataBuffer().getIndex() + buffer.getDataBuffer().getLength(); ++i) {
            if (buffer.getDataBuffer().getData()[i] == 0) continue;
            return true;
        }
        return false;
    }

    protected void processSpeakerFrame(AudioFrame frame) {
        if (this.__native != null) {
            this.__native.render(frame);
        }
        if (this.__millis == -1 && this.hasData((AudioBuffer)frame.getBuffer())) {
            this.__millis = (int)(this.__watch.getElapsedTicks() / 10000L);
        }
    }
}

