/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.Dynamic;
import fm.Global;
import fm.Serializer;

public class Record
extends Dynamic {
    private String __key;
    private boolean __priv;
    private String __valueJson;
    private boolean _validate;

    public Record duplicate() throws Exception {
        return new Record(this.getKey(), this.getValueJson(), this.getPrivate());
    }

    public boolean equals(Object obj) {
        Record record = (Record)((Object)Global.tryCast((Object)obj, Record.class));
        return Global.equals((Object)((Object)record), (Object)((Object)this));
    }

    public static Record fromJson(String recordJson) throws Exception {
        return fm.websync.Serializer.deserializeRecord(recordJson);
    }

    public static Record[] fromJsonMultiple(String recordsJson) throws Exception {
        return fm.websync.Serializer.deserializeRecordArray(recordsJson);
    }

    public String getKey() {
        return this.__key;
    }

    public boolean getPrivate() {
        return this.__priv;
    }

    boolean getValidate() {
        return this._validate;
    }

    public String getValueJson() {
        return this.__valueJson;
    }

    public int hashCode() {
        int num = 17;
        if (this.getKey() != null) {
            num = num * 23 + this.getKey().hashCode();
        }
        if (this.getValueJson() != null) {
            num = num * 23 + this.getValueJson().hashCode();
        }
        return num * 23 + new Boolean(this.getPrivate()).hashCode();
    }

    public Record(String key, String valueJson, boolean priv) throws Exception {
        this();
        this.setKey(key);
        this.setValueJson(valueJson);
        this.setPrivate(priv);
    }

    public Record(String key, String valueJson) throws Exception {
        this(key, valueJson, false);
    }

    private Record() {
        this.setValidate(true);
    }

    public Record(String key) throws Exception {
        this(key, null);
    }

    public void setKey(String value) throws Exception {
        if (value == null) {
            throw new Exception("key cannot be null.");
        }
        this.__key = value;
        super.setIsDirty(true);
    }

    public void setPrivate(boolean value) {
        this.__priv = value;
        super.setIsDirty(true);
    }

    void setValidate(boolean value) {
        this._validate = value;
    }

    public void setValueJson(String value) throws Exception {
        if (this.getValidate() && value != null && !Serializer.isValidJson((String)value)) {
            throw new Exception("value is not valid JSON.");
        }
        this.__valueJson = value;
        super.setIsDirty(true);
    }

    public String toJson() {
        return Record.toJson(this);
    }

    public static String toJson(Record record) {
        return fm.websync.Serializer.serializeRecord(record);
    }

    public static String toJsonMultiple(Record[] records) {
        return fm.websync.Serializer.serializeRecordArray(records);
    }

    public String toString() {
        return this.toJson();
    }
}

