/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.EmptyFunction;
import fm.SingleFunction;
import fm.websync.HttpMessageTransfer;
import fm.websync.MessageTransfer;
import fm.websync.WebSocketMessageTransfer;

public class MessageTransferFactory {
    private static EmptyFunction<MessageTransfer> _createHttpMessageTransfer;
    private static SingleFunction<String, WebSocketMessageTransfer> _createWebSocketMessageTransfer;

    static MessageTransfer defaultCreateHttpMessageTransfer() {
        return new HttpMessageTransfer();
    }

    static WebSocketMessageTransfer defaultCreateWebSocketMessageTransfer(String requestUrl) {
        return new WebSocketMessageTransfer(requestUrl);
    }

    public static EmptyFunction<MessageTransfer> getCreateHttpMessageTransfer() {
        return _createHttpMessageTransfer;
    }

    public static SingleFunction<String, WebSocketMessageTransfer> getCreateWebSocketMessageTransfer() {
        return _createWebSocketMessageTransfer;
    }

    public static MessageTransfer getHttpMessageTransfer() {
        MessageTransfer transfer;
        if (MessageTransferFactory.getCreateHttpMessageTransfer() == null) {
            MessageTransferFactory.setCreateHttpMessageTransfer(new EmptyFunction<MessageTransfer>(){

                public MessageTransfer invoke() {
                    try {
                        return MessageTransferFactory.defaultCreateHttpMessageTransfer();
                    }
                    catch (Exception _var0) {
                        return null;
                    }
                }
            });
        }
        if ((transfer = (MessageTransfer)MessageTransferFactory.getCreateHttpMessageTransfer().invoke()) == null) {
            transfer = MessageTransferFactory.defaultCreateHttpMessageTransfer();
        }
        return transfer;
    }

    public static WebSocketMessageTransfer getWebSocketMessageTransfer(String requestUrl) {
        WebSocketMessageTransfer transfer;
        if (MessageTransferFactory.getCreateWebSocketMessageTransfer() == null) {
            MessageTransferFactory.setCreateWebSocketMessageTransfer(new SingleFunction<String, WebSocketMessageTransfer>(){

                public WebSocketMessageTransfer invoke(String requestUrl) {
                    try {
                        return MessageTransferFactory.defaultCreateWebSocketMessageTransfer(requestUrl);
                    }
                    catch (Exception _var0) {
                        return null;
                    }
                }
            });
        }
        if ((transfer = (WebSocketMessageTransfer)MessageTransferFactory.getCreateWebSocketMessageTransfer().invoke((Object)requestUrl)) == null) {
            transfer = MessageTransferFactory.defaultCreateWebSocketMessageTransfer(requestUrl);
        }
        return transfer;
    }

    public static void setCreateHttpMessageTransfer(EmptyFunction<MessageTransfer> value) {
        _createHttpMessageTransfer = value;
    }

    public static void setCreateWebSocketMessageTransfer(SingleFunction<String, WebSocketMessageTransfer> value) {
        _createWebSocketMessageTransfer = value;
    }
}

