/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.ArrayExtensions;
import fm.Dynamic;
import fm.Holder;
import fm.StringComparison;
import fm.StringExtensions;
import fm.websync.Extensions;
import fm.websync.MetaChannels;
import fm.websync.Record;
import java.util.ArrayList;

public abstract class Extensible
extends Dynamic {
    private Extensions __extensions;
    public static String _acknowledgementExtensionName = "fm.ack";
    public static String _disableBinaryExtensionName = "fm.dbin";
    public static String _lastClientIdExtensionName = "fm.lcid";
    public static String _lastSessionIdExtensionName = "fm.lsid";
    public static String _metaExtensionName = "fm.meta";
    public static String _notifyClientIdExtensionName = "fm.notify";
    public static String _notifyingClientExtensionName = "fm.notifying";
    public static String _publishingClientExtensionName = "fm.publishing";
    public static String _serverActionsExtensionName = "fm.server";
    public static String _serverTimeoutExtensionName = "fm.timeout";
    public static String _sessionIdExtensionName = "fm.sessionId";
    public static String _tagExtensionName = "fm.tag";

    static Record convertKeyToRecord(String key) throws Exception {
        return new Record(key);
    }

    static String convertRecordToKey(Record record) {
        return record.getKey();
    }

    public void copyExtensions(Extensible extensible) throws Exception {
        for (String str : extensible.getExtensionNames()) {
            this.setExtensionValueJson(str, extensible.getExtensionValueJson(str), false);
        }
    }

    protected Extensible() {
    }

    public int getExtensionCount() {
        return this.getExtensions().getCount();
    }

    public ArrayList<String> getExtensionNames() {
        return this.getExtensions().getNames();
    }

    public Extensions getExtensions() {
        if (this.__extensions == null) {
            this.__extensions = new Extensions();
        }
        return this.__extensions;
    }

    public String getExtensionValueJson(String name) {
        return this.getExtensions().getValueJson(name);
    }

    public String getMetaJson() {
        return this.getExtensionValueJson("fm.meta");
    }

    public void setExtensions(Extensions value) {
        this.__extensions = value == null ? new Extensions() : value;
    }

    public void setExtensionValueJson(String name, String valueJson, boolean validate) throws Exception {
        this.getExtensions().setValueJson(name, valueJson, validate);
        super.setIsDirty(true);
    }

    public void setExtensionValueJson(String name, String valueJson) throws Exception {
        this.getExtensions().setValueJson(name, valueJson);
        super.setIsDirty(true);
    }

    public void setMetaJson(String value) throws Exception {
        this.setExtensionValueJson("fm.meta", value);
    }

    protected static String sharedGetChannel(String[] channels) {
        if (channels == null || ArrayExtensions.getLength((Object[])channels) == 0) {
            return null;
        }
        return channels[0];
    }

    protected static String[] sharedGetChannels(String[] channels) {
        return channels;
    }

    protected static String sharedGetKey(Record[] records) {
        Record record = Extensible.sharedGetRecord(records);
        if (record == null) {
            return null;
        }
        return Extensible.convertRecordToKey(record);
    }

    protected static String[] sharedGetKeys(Record[] records) {
        if ((records = Extensible.sharedGetRecords(records)) == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Record record : records) {
            list.add(Extensible.convertRecordToKey(record));
        }
        return list.toArray(new String[0]);
    }

    protected static Record sharedGetRecord(Record[] records) {
        if (records == null || ArrayExtensions.getLength((Object[])records) == 0) {
            return null;
        }
        return records[0];
    }

    protected static Record[] sharedGetRecords(Record[] records) {
        return records;
    }

    protected static String[] sharedSetChannel(String channel, boolean validate) throws Exception {
        if (channel == null) {
            return null;
        }
        String error = null;
        Holder _var0 = new Holder(error);
        boolean _var1 = Extensible.validateChannel(channel, (Holder<String>)_var0);
        error = (String)_var0.getValue();
        if (validate && !_var1) {
            throw new Exception(StringExtensions.format((String)"Invalid channel. {0}", (Object)error));
        }
        return new String[]{channel};
    }

    protected static String[] sharedSetChannel(String channel) throws Exception {
        return Extensible.sharedSetChannel(channel, true);
    }

    protected static String[] sharedSetChannels(String[] channels, boolean validate) throws Exception {
        if (channels != null) {
            for (String str : channels) {
                String error = null;
                Holder _var0 = new Holder(error);
                boolean _var1 = Extensible.validateChannel(str, (Holder<String>)_var0);
                error = (String)_var0.getValue();
                if (!validate || _var1) continue;
                throw new Exception(StringExtensions.format((String)"Invalid channel. {0}", (Object)error));
            }
        }
        return channels;
    }

    protected static String[] sharedSetChannels(String[] channels) throws Exception {
        return Extensible.sharedSetChannels(channels, true);
    }

    protected static Record[] sharedSetKey(String key, boolean validate) throws Exception {
        if (key == null) {
            return null;
        }
        Record record = Extensible.convertKeyToRecord(key);
        String error = null;
        Holder _var0 = new Holder(error);
        boolean _var1 = Extensible.validateRecord(record, (Holder<String>)_var0);
        error = (String)_var0.getValue();
        if (validate && !_var1) {
            throw new Exception(StringExtensions.format((String)"Invalid record. {0}", (Object)error));
        }
        return new Record[]{record};
    }

    protected static Record[] sharedSetKey(String key) throws Exception {
        return Extensible.sharedSetKey(key, true);
    }

    protected static Record[] sharedSetKeys(String[] keys) throws Exception {
        return Extensible.sharedSetKeys(keys, true);
    }

    protected static Record[] sharedSetKeys(String[] keys, boolean validate) throws Exception {
        if (keys == null) {
            return null;
        }
        ArrayList<Record> list = new ArrayList<Record>();
        for (String str : keys) {
            Record record = Extensible.convertKeyToRecord(str);
            String error = null;
            Holder _var0 = new Holder(error);
            boolean _var1 = Extensible.validateRecord(record, (Holder<String>)_var0);
            error = (String)_var0.getValue();
            if (validate && !_var1) {
                throw new Exception(StringExtensions.format((String)"Invalid record. {0}", (Object)error));
            }
            list.add(record);
        }
        return list.toArray(new Record[0]);
    }

    protected static Record[] sharedSetRecord(Record record, boolean validate) throws Exception {
        String error = null;
        Holder _var0 = new Holder(error);
        boolean _var1 = Extensible.validateRecord(record, (Holder<String>)_var0);
        error = (String)_var0.getValue();
        if (validate && !_var1) {
            throw new Exception(StringExtensions.format((String)"Invalid record. {0}", (Object)error));
        }
        return new Record[]{record};
    }

    protected static Record[] sharedSetRecord(Record record) throws Exception {
        return Extensible.sharedSetRecord(record, true);
    }

    protected static Record[] sharedSetRecords(Record[] records, boolean validate) throws Exception {
        if (records != null) {
            for (Record record : records) {
                String error = null;
                Holder _var0 = new Holder(error);
                boolean _var1 = Extensible.validateRecord(record, (Holder<String>)_var0);
                error = (String)_var0.getValue();
                if (!validate || _var1) continue;
                throw new Exception(StringExtensions.format((String)"Invalid record. {0}", (Object)error));
            }
        }
        return records;
    }

    protected static Record[] sharedSetRecords(Record[] records) throws Exception {
        return Extensible.sharedSetRecords(records, true);
    }

    public static boolean validateChannel(String channel, Holder<String> error) {
        if (channel == null) {
            error.setValue((Object)"Channel is null.");
            return false;
        }
        if (!StringExtensions.startsWith((String)channel, (String)"/", (StringComparison)StringComparison.Ordinal)) {
            error.setValue((Object)"Channel must start with a forward-slash (/).");
            return false;
        }
        if (StringExtensions.indexOf((String)channel, (String)"*", (StringComparison)StringComparison.Ordinal) >= 0) {
            error.setValue((Object)"Channel may not contain asterisks (*).");
            return false;
        }
        if (MetaChannels.isReservedChannel(channel)) {
            error.setValue((Object)"Channel is reserved.");
            return false;
        }
        error.setValue(null);
        return true;
    }

    public static boolean validateRecord(Record record, Holder<String> error) {
        if (record == null) {
            error.setValue((Object)"Record is null.");
            return false;
        }
        if (StringExtensions.isNullOrEmpty((String)record.getKey())) {
            error.setValue((Object)"Key is null or empty.");
            return false;
        }
        error.setValue(null);
        return true;
    }
}

