/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.AsyncException;
import fm.Delegate;
import fm.Dynamic;
import fm.Global;
import fm.Guid;
import fm.HashMapExtensions;
import fm.HttpRequestCreatedArgs;
import fm.HttpResponseReceivedArgs;
import fm.HttpTransfer;
import fm.SingleAction;
import fm.StringComparison;
import fm.StringExtensions;
import fm.websync.ConcurrencyMode;
import fm.websync.Defaults;
import fm.websync.MessageRequestCreatedArgs;
import fm.websync.MessageResponseReceivedArgs;
import fm.websync.UnhandledExceptionArgs;
import java.util.HashMap;

public abstract class BaseClient
extends Dynamic {
    private String __domainName;
    private String __requestUrl;
    private ConcurrencyMode _concurrencyMode;
    private boolean _disableBinary;
    private Guid _domainKey;
    private static HashMap<String, String> _headers;
    static String _invalidResponseMessage;
    private SingleAction<HttpRequestCreatedArgs> _onHttpRequestCreated;
    private SingleAction<HttpResponseReceivedArgs> _onHttpResponseReceived;
    private SingleAction<MessageRequestCreatedArgs> _onRequestCreated;
    private SingleAction<MessageResponseReceivedArgs> _onResponseReceived;
    private SingleAction<UnhandledExceptionArgs> _onUnhandledException;
    private int _requestTimeout;

    public SingleAction<HttpRequestCreatedArgs> addOnHttpRequestCreated(SingleAction<HttpRequestCreatedArgs> value) {
        this._onHttpRequestCreated = (SingleAction)Delegate.combine(this._onHttpRequestCreated, value);
        return value;
    }

    public SingleAction<HttpResponseReceivedArgs> addOnHttpResponseReceived(SingleAction<HttpResponseReceivedArgs> value) {
        this._onHttpResponseReceived = (SingleAction)Delegate.combine(this._onHttpResponseReceived, value);
        return value;
    }

    public SingleAction<MessageRequestCreatedArgs> addOnRequestCreated(SingleAction<MessageRequestCreatedArgs> value) {
        this._onRequestCreated = (SingleAction)Delegate.combine(this._onRequestCreated, value);
        return value;
    }

    public SingleAction<MessageResponseReceivedArgs> addOnResponseReceived(SingleAction<MessageResponseReceivedArgs> value) {
        this._onResponseReceived = (SingleAction)Delegate.combine(this._onResponseReceived, value);
        return value;
    }

    public SingleAction<UnhandledExceptionArgs> addOnUnhandledException(SingleAction<UnhandledExceptionArgs> value) {
        this._onUnhandledException = (SingleAction)Delegate.combine(this._onUnhandledException, value);
        return value;
    }

    protected BaseClient() {
        this.setRequestTimeout(15000);
        this.setDomainKey(Defaults.getDomainKey());
        this.setDomainName(Defaults.getDomainName());
        this.setConcurrencyMode(ConcurrencyMode.Low);
    }

    protected HashMap<String, String> createHeaders() {
        if (Global.equals((Object)((Object)this.getConcurrencyMode()), (Object)((Object)ConcurrencyMode.High))) {
            if (_headers == null) {
                _headers = this.createHeadersNoCache();
            }
            return _headers;
        }
        return this.createHeadersNoCache();
    }

    private HashMap<String, String> createHeadersNoCache() {
        HashMap<String, String> values = new HashMap<String, String>();
        if (!Global.equals((Object)this.getDomainName(), (Object)Defaults.getDomainName())) {
            HashMapExtensions.getItem(values).put("X-FM-DomainName", this.getDomainName());
        }
        if (!Global.equals((Object)this.getDomainKey(), (Object)Defaults.getDomainKey())) {
            HashMapExtensions.getItem(values).put("X-FM-DomainKey", this.getDomainKey().toString());
        }
        return values;
    }

    public ConcurrencyMode getConcurrencyMode() {
        return this._concurrencyMode;
    }

    public boolean getDisableBinary() {
        return this._disableBinary;
    }

    public Guid getDomainKey() {
        return this._domainKey;
    }

    public String getDomainKeyString() {
        return this.getDomainKey().toString();
    }

    public String getDomainName() {
        return this.__domainName;
    }

    public int getRequestTimeout() {
        return this._requestTimeout;
    }

    public String getRequestUrl() {
        return this.__requestUrl;
    }

    void internalOnHttpRequestCreated(HttpRequestCreatedArgs e) throws Exception {
        this.raiseBaseEvent(this._onHttpRequestCreated, e, "OnHttpRequestCreated");
    }

    void internalOnHttpResponseReceived(HttpResponseReceivedArgs e) throws Exception {
        this.raiseBaseEvent(this._onHttpResponseReceived, e, "OnHttpResponseReceived");
    }

    void internalOnRequestCreated(MessageRequestCreatedArgs e) throws Exception {
        this.raiseBaseEvent(this._onRequestCreated, e, "OnRequestCreated");
    }

    void internalOnResponseReceived(MessageResponseReceivedArgs e) throws Exception {
        this.raiseBaseEvent(this._onResponseReceived, e, "OnResponseReceived");
    }

    private <T> void raiseBaseEvent(SingleAction<T> eventMethod, T args, String eventName) throws Exception {
        block3: {
            if (eventMethod != null) {
                try {
                    eventMethod.invoke(args);
                }
                catch (Exception exception) {
                    if (this.raiseUnhandledException(exception)) break block3;
                    AsyncException.asyncThrow((Exception)exception, (String)StringExtensions.format((String)"BaseClient -> {0}", (Object)eventName));
                }
            }
        }
    }

    public boolean raiseUnhandledException(Exception exception) throws Exception {
        SingleAction<UnhandledExceptionArgs> onUnhandledException = this._onUnhandledException;
        if (onUnhandledException != null) {
            UnhandledExceptionArgs args2 = new UnhandledExceptionArgs();
            args2.__exception = exception;
            UnhandledExceptionArgs p = args2;
            try {
                onUnhandledException.invoke((Object)p);
            }
            catch (Exception exception2) {
                AsyncException.asyncThrow((Exception)exception2, (String)"BaseClient -> OnUnhandledException");
            }
            return p.getHandled();
        }
        return false;
    }

    public void removeOnHttpRequestCreated(SingleAction<HttpRequestCreatedArgs> value) {
        this._onHttpRequestCreated = (SingleAction)Delegate.remove(this._onHttpRequestCreated, value);
    }

    public void removeOnHttpResponseReceived(SingleAction<HttpResponseReceivedArgs> value) {
        this._onHttpResponseReceived = (SingleAction)Delegate.remove(this._onHttpResponseReceived, value);
    }

    public void removeOnRequestCreated(SingleAction<MessageRequestCreatedArgs> value) {
        this._onRequestCreated = (SingleAction)Delegate.remove(this._onRequestCreated, value);
    }

    public void removeOnResponseReceived(SingleAction<MessageResponseReceivedArgs> value) {
        this._onResponseReceived = (SingleAction)Delegate.remove(this._onResponseReceived, value);
    }

    public void removeOnUnhandledException(SingleAction<UnhandledExceptionArgs> value) {
        this._onUnhandledException = (SingleAction)Delegate.remove(this._onUnhandledException, value);
    }

    private static String sanitizeDomainName(String domainName) {
        if (StringExtensions.startsWith((String)domainName, (String)"http://", (StringComparison)StringComparison.Ordinal)) {
            domainName = domainName.substring(StringExtensions.getLength((String)"http://"));
        } else if (StringExtensions.startsWith((String)domainName, (String)"https://", (StringComparison)StringComparison.Ordinal)) {
            domainName = domainName.substring(StringExtensions.getLength((String)"https://"));
        }
        int index = StringExtensions.indexOf((String)domainName, (String)"/");
        if (index != -1) {
            domainName = StringExtensions.substring((String)domainName, (int)0, (int)index);
        }
        return domainName;
    }

    public void setConcurrencyMode(ConcurrencyMode value) {
        this._concurrencyMode = value;
    }

    public void setDisableBinary(boolean value) {
        this._disableBinary = value;
    }

    public void setDomainKey(Guid value) {
        this._domainKey = value;
    }

    public void setDomainKeyString(String value) {
        this.setDomainKey(new Guid(value));
    }

    public void setDomainName(String value) {
        if (value == null) {
            value = Defaults.getDomainName();
        }
        this.__domainName = BaseClient.sanitizeDomainName(value);
    }

    public void setRequestTimeout(int value) {
        this._requestTimeout = value;
    }

    public void setRequestUrl(String value) throws Exception {
        if (value == null) {
            throw new Exception("Request URL cannot be null.");
        }
        this.__requestUrl = HttpTransfer.replaceWildcards((String)value);
    }

    static {
        _invalidResponseMessage = "Invalid response received from server.";
        _headers = null;
    }
}

