/*
 * Decompiled with CFR 0.152.
 */
package fm.websync.subscribers;

import fm.AsyncException;
import fm.DoubleAction;
import fm.Global;
import fm.SingleAction;
import fm.StringExtensions;
import fm.websync.Client;
import fm.websync.ClientSubscribeEndArgs;
import fm.websync.ClientSubscribeRequestArgs;
import fm.websync.ClientSubscribeResponseArgs;
import fm.websync.ClientUnsubscribeRequestArgs;
import fm.websync.ClientUnsubscribeResponseArgs;
import fm.websync.Extensible;
import fm.websync.SubscribeArgs;
import fm.websync.SubscribeReceiveArgs;
import fm.websync.UnsubscribeArgs;
import fm.websync.subscribers.ClientSubscribeArgs;
import fm.websync.subscribers.ClientUnsubscribeArgs;
import fm.websync.subscribers.Serializer;
import fm.websync.subscribers.SubscriberChange;
import fm.websync.subscribers.SubscriberChangeType;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class SubscribeArgsExtensions {
    private static String _onClientSubscribePropertyName = "fm.subscribers.onClientSubscribe";
    private static String _onClientUnsubscribePropertyName = "fm.subscribers.onClientUnsubscribe";

    private static void client_OnReceive(SubscribeReceiveArgs e) throws Exception {
        block10: {
            SubscriberChange change = Serializer.deserializeSubscriberChange(e.getDataJson());
            if (!Global.equals((Object)change.getClient().getClientId(), (Object)e.getClient().getClientId())) {
                HashMap dynamicValue = (HashMap)Global.tryCast((Object)e.getClient().getDynamicValue(SubscribeArgsExtensions.getDynamicPropertiesKey(e.getChannel())), HashMap.class);
                if (Global.equals((Object)((Object)change.getType()), (Object)((Object)SubscriberChangeType.Subscribe))) {
                    SingleAction action = (SingleAction)Global.tryCast((Object)e.getClient().getDynamicValue(SubscribeArgsExtensions.getOnClientSubscribeKey(e.getChannel())), SingleAction.class);
                    if (action != null) {
                        ClientSubscribeArgs args2 = new ClientSubscribeArgs(e.getChannel().substring(StringExtensions.getLength((String)"/fm/subscribers")), change.getClient());
                        args2.setTimestamp(e.getTimestamp());
                        args2.setClient(e.getClient());
                        args2.setDynamicProperties(dynamicValue);
                        ClientSubscribeArgs p = args2;
                        p.copyExtensions((Extensible)e);
                        try {
                            action.invoke((Object)p);
                        }
                        catch (Exception exception1) {
                            Exception exception = exception1;
                            if (!e.getClient().raiseUnhandledException(exception)) {
                                AsyncException.asyncThrow((Exception)exception, (String)"Client -> Subscribe -> OnClientSubscribe");
                            }
                        }
                    }
                } else {
                    SingleAction action2 = (SingleAction)Global.tryCast((Object)e.getClient().getDynamicValue(SubscribeArgsExtensions.getOnClientUnsubscribeKey(e.getChannel())), SingleAction.class);
                    if (action2 != null) {
                        ClientUnsubscribeArgs args4 = new ClientUnsubscribeArgs(e.getChannel().substring(StringExtensions.getLength((String)"/fm/subscribers")), change.getClient());
                        args4.setTimestamp(e.getTimestamp());
                        args4.setClient(e.getClient());
                        args4.setDynamicProperties(dynamicValue);
                        ClientUnsubscribeArgs args3 = args4;
                        args3.copyExtensions((Extensible)e);
                        try {
                            action2.invoke((Object)args3);
                        }
                        catch (Exception exception2) {
                            Exception exception = exception2;
                            if (e.getClient().raiseUnhandledException(exception)) break block10;
                            AsyncException.asyncThrow((Exception)exception, (String)"Client -> Subscribe -> OnClientUnsubscribe");
                        }
                    }
                }
            }
        }
    }

    private static void client_OnSubscribeEnd(Client client, ClientSubscribeEndArgs args) throws Exception {
        if (args.getException() == null) {
            SingleAction<ClientSubscribeArgs> onClientSubscribe = SubscribeArgsExtensions.getOnClientSubscribe((SubscribeArgs)args.getMethodArgs());
            SingleAction<ClientUnsubscribeArgs> onClientUnsubscribe = SubscribeArgsExtensions.getOnClientUnsubscribe((SubscribeArgs)args.getMethodArgs());
            if (onClientSubscribe != null || onClientUnsubscribe != null) {
                for (String str : args.getResponse().getChannels()) {
                    String subscribersChannel = StringExtensions.concat((String)"/fm/subscribers", (String)str);
                    client.setDynamicValue(SubscribeArgsExtensions.getOnClientSubscribeKey(subscribersChannel), onClientSubscribe);
                    client.setDynamicValue(SubscribeArgsExtensions.getOnClientUnsubscribeKey(subscribersChannel), onClientUnsubscribe);
                    client.setDynamicValue(SubscribeArgsExtensions.getDynamicPropertiesKey(subscribersChannel), (Object)((SubscribeArgs)args.getMethodArgs()).getDynamicProperties());
                    args.getClient().setCustomOnReceive(subscribersChannel, (SingleAction)new SingleAction<SubscribeReceiveArgs>(){

                        public void invoke(SubscribeReceiveArgs e) {
                            try {
                                SubscribeArgsExtensions.client_OnReceive(e);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }
    }

    private static void client_OnSubscribeRequest(Client client, ClientSubscribeRequestArgs args) throws Exception {
        SingleAction<ClientSubscribeArgs> onClientSubscribe = SubscribeArgsExtensions.getOnClientSubscribe((SubscribeArgs)args.getMethodArgs());
        SingleAction<ClientUnsubscribeArgs> onClientUnsubscribe = SubscribeArgsExtensions.getOnClientUnsubscribe((SubscribeArgs)args.getMethodArgs());
        if (onClientSubscribe != null || onClientUnsubscribe != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String str : ((SubscribeArgs)args.getMethodArgs()).getChannels()) {
                list.add(str);
                list.add(StringExtensions.concat((String)"/fm/subscribers", (String)str));
            }
            ((SubscribeArgs)args.getMethodArgs()).setChannels(list.toArray(new String[0]));
        }
    }

    private static void client_OnSubscribeResponse(Client client, ClientSubscribeResponseArgs args) throws Exception {
        if (args.getException() == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String str : args.getResponse().getChannels()) {
                if (str.startsWith("/fm/subscribers/")) continue;
                list.add(str);
            }
            ((SubscribeArgs)args.getMethodArgs()).setChannels(list.toArray(new String[0]));
            args.getResponse().setChannels(list.toArray(new String[0]));
        }
    }

    private static void client_OnUnsubscribeRequest(Client client, ClientUnsubscribeRequestArgs e) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : ((UnsubscribeArgs)e.getMethodArgs()).getChannels()) {
            list.add(str);
            list.add(StringExtensions.concat((String)"/fm/subscribers", (String)str));
        }
        ((UnsubscribeArgs)e.getMethodArgs()).setChannels(list.toArray(new String[0]));
    }

    private static void client_OnUnsubscribeResponse(Client client, ClientUnsubscribeResponseArgs e) throws Exception {
        if (e.getException() == null) {
            for (String str : e.getResponse().getChannels()) {
                if (!str.startsWith("/fm/subscribers")) continue;
                e.getClient().unsetCustomOnReceive(str);
                e.getClient().unsetDynamicValue(SubscribeArgsExtensions.getOnClientSubscribeKey(str));
                e.getClient().unsetDynamicValue(SubscribeArgsExtensions.getOnClientUnsubscribeKey(str));
                e.getClient().unsetDynamicValue(SubscribeArgsExtensions.getDynamicPropertiesKey(str));
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String str : e.getResponse().getChannels()) {
                if (str.startsWith("/fm/subscribers/")) continue;
                list.add(str);
            }
            ((UnsubscribeArgs)e.getMethodArgs()).setChannels(list.toArray(new String[0]));
            e.getResponse().setChannels(list.toArray(new String[0]));
        }
    }

    private static String getDynamicPropertiesKey(String subscribersChannel) {
        return StringExtensions.concat((String)"fm.subscribers.dynamicProperties", (String)subscribersChannel);
    }

    public static SingleAction<ClientSubscribeArgs> getOnClientSubscribe(SubscribeArgs args) {
        SingleAction _var0 = (SingleAction)args.getDynamicValue(_onClientSubscribePropertyName);
        return _var0;
    }

    private static String getOnClientSubscribeKey(String subscribersChannel) {
        return StringExtensions.concat((String)"fm.subscribers.onClientSubscribe", (String)subscribersChannel);
    }

    public static SingleAction<ClientUnsubscribeArgs> getOnClientUnsubscribe(SubscribeArgs args) {
        SingleAction _var0 = (SingleAction)args.getDynamicValue(_onClientUnsubscribePropertyName);
        return _var0;
    }

    private static String getOnClientUnsubscribeKey(String subscribersChannel) {
        return StringExtensions.concat((String)"fm.subscribers.onClientUnsubscribe", (String)subscribersChannel);
    }

    public static SubscribeArgs setOnClientSubscribe(SubscribeArgs args, SingleAction<ClientSubscribeArgs> onClientSubscribe) {
        args.setDynamicValue(_onClientSubscribePropertyName, onClientSubscribe);
        return args;
    }

    public static SubscribeArgs setOnClientUnsubscribe(SubscribeArgs args, SingleAction<ClientUnsubscribeArgs> onClientUnsubscribe) {
        args.setDynamicValue(_onClientUnsubscribePropertyName, onClientUnsubscribe);
        return args;
    }

    static {
        Client.addOnSubscribeRequest((DoubleAction)new DoubleAction<Client, ClientSubscribeRequestArgs>(){

            public void invoke(Client client, ClientSubscribeRequestArgs args) {
                try {
                    SubscribeArgsExtensions.client_OnSubscribeRequest(client, args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Client.addOnSubscribeResponse((DoubleAction)new DoubleAction<Client, ClientSubscribeResponseArgs>(){

            public void invoke(Client client, ClientSubscribeResponseArgs args) {
                try {
                    SubscribeArgsExtensions.client_OnSubscribeResponse(client, args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Client.addOnSubscribeEnd((DoubleAction)new DoubleAction<Client, ClientSubscribeEndArgs>(){

            public void invoke(Client client, ClientSubscribeEndArgs args) {
                try {
                    SubscribeArgsExtensions.client_OnSubscribeEnd(client, args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Client.addOnUnsubscribeRequest((DoubleAction)new DoubleAction<Client, ClientUnsubscribeRequestArgs>(){

            public void invoke(Client client, ClientUnsubscribeRequestArgs e) {
                try {
                    SubscribeArgsExtensions.client_OnUnsubscribeRequest(client, e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Client.addOnUnsubscribeResponse((DoubleAction)new DoubleAction<Client, ClientUnsubscribeResponseArgs>(){

            public void invoke(Client client, ClientUnsubscribeResponseArgs e) {
                try {
                    SubscribeArgsExtensions.client_OnUnsubscribeResponse(client, e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

