/*
 * Decompiled with CFR 0.152.
 */
package fm.websync.chat;

import fm.AsyncException;
import fm.Global;
import fm.HashMapExtensions;
import fm.Holder;
import fm.Log;
import fm.NullableGuid;
import fm.Serializer;
import fm.SingleAction;
import fm.StringExtensions;
import fm.websync.BaseFailureArgs;
import fm.websync.BaseOutputArgs;
import fm.websync.BindArgs;
import fm.websync.BindFailureArgs;
import fm.websync.BindSuccessArgs;
import fm.websync.Client;
import fm.websync.Extensible;
import fm.websync.Record;
import fm.websync.SubscribeArgs;
import fm.websync.SubscribeFailureArgs;
import fm.websync.SubscribeReceiveArgs;
import fm.websync.SubscribeSuccessArgs;
import fm.websync.SubscribedClient;
import fm.websync.UnbindArgs;
import fm.websync.UnbindFailureArgs;
import fm.websync.UnbindSuccessArgs;
import fm.websync.UnsubscribeArgs;
import fm.websync.UnsubscribeFailureArgs;
import fm.websync.UnsubscribeSuccessArgs;
import fm.websync.chat.ChatUser;
import fm.websync.chat.JoinArgs;
import fm.websync.chat.JoinCompleteArgs;
import fm.websync.chat.JoinFailureArgs;
import fm.websync.chat.JoinReceiveArgs;
import fm.websync.chat.JoinState;
import fm.websync.chat.JoinSuccessArgs;
import fm.websync.chat.LeaveArgs;
import fm.websync.chat.LeaveCompleteArgs;
import fm.websync.chat.LeaveFailureArgs;
import fm.websync.chat.LeaveState;
import fm.websync.chat.LeaveSuccessArgs;
import fm.websync.chat.UserClientJoinArgs;
import fm.websync.chat.UserClientLeaveArgs;
import fm.websync.chat.UserJoinArgs;
import fm.websync.chat.UserLeaveArgs;
import fm.websync.subscribers.ClientSubscribeArgs;
import fm.websync.subscribers.ClientUnsubscribeArgs;
import fm.websync.subscribers.SubscribeArgsExtensions;
import fm.websync.subscribers.SubscribeSuccessArgsExtensions;
import fm.websync.subscribers.SubscriberChangeType;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ClientExtensions {
    private static String _argsKey;
    private static String _joinStateKey;
    private static String _leaveStateKey;
    private static String _userCacheKey;
    private static String _userCacheLockKey;
    private static String _userIdKey;
    private static String _userNicknameKey;

    private static String getRecordValueJson(HashMap<String, Record> records, String key) {
        if (records.containsKey(key)) {
            return ((Record)HashMapExtensions.getItem(records).get(key)).getValueJson();
        }
        return null;
    }

    private static String getRecordValueJsonFromArray(Record[] records, String key) {
        for (Record record : records) {
            if (!Global.equals((Object)record.getKey(), (Object)key)) continue;
            return record.getValueJson();
        }
        return null;
    }

    private static ChatUser getUser(NullableGuid clientId, HashMap<String, Record> records, String channel) throws Exception {
        return new ChatUser(ClientExtensions.getUserId(records, channel), ClientExtensions.getUserNickname(records, channel), clientId, records);
    }

    private static String getUserId(HashMap<String, Record> records, String channel) throws Exception {
        String recordValueJson = ClientExtensions.getRecordValueJson(records, ClientExtensions.getUserIdKey(channel));
        if (recordValueJson == null) {
            return null;
        }
        return Serializer.deserializeString((String)recordValueJson);
    }

    private static String getUserIdFromArray(Record[] records, String channel) throws Exception {
        String recordValueJsonFromArray = ClientExtensions.getRecordValueJsonFromArray(records, ClientExtensions.getUserIdKey(channel));
        if (recordValueJsonFromArray == null) {
            return null;
        }
        return Serializer.deserializeString((String)recordValueJsonFromArray);
    }

    public static String getUserIdKey(String channel) {
        return StringExtensions.concat((String)_userIdKey, (String)channel);
    }

    private static String getUserNickname(HashMap<String, Record> records, String channel) throws Exception {
        String recordValueJson = ClientExtensions.getRecordValueJson(records, ClientExtensions.getUserNicknameKey(channel));
        if (recordValueJson == null) {
            return null;
        }
        return Serializer.deserializeString((String)recordValueJson);
    }

    private static String getUserNicknameFromArray(Record[] records, String channel) throws Exception {
        String recordValueJsonFromArray = ClientExtensions.getRecordValueJsonFromArray(records, ClientExtensions.getUserNicknameKey(channel));
        if (recordValueJsonFromArray == null) {
            return null;
        }
        return Serializer.deserializeString((String)recordValueJsonFromArray);
    }

    public static String getUserNicknameKey(String channel) {
        return StringExtensions.concat((String)_userNicknameKey, (String)channel);
    }

    public static Client join(Client client, JoinArgs joinArgs) throws Exception {
        if (StringExtensions.isNullOrEmpty((String)joinArgs.getChannel())) {
            throw new Exception("channel cannot be null.");
        }
        if (StringExtensions.isNullOrEmpty((String)joinArgs.getUserId())) {
            throw new Exception("userId cannot be null.");
        }
        if (StringExtensions.isNullOrEmpty((String)joinArgs.getUserNickname())) {
            throw new Exception("userNickname cannot be null.");
        }
        client.startBatch();
        BindArgs args3 = new BindArgs(new Record[]{new Record(ClientExtensions.getUserIdKey(joinArgs.getChannel()), Serializer.serializeString((String)joinArgs.getUserId())), new Record(ClientExtensions.getUserNicknameKey(joinArgs.getChannel()), Serializer.serializeString((String)joinArgs.getUserNickname()))});
        args3.setRequestUrl(joinArgs.getRequestUrl());
        args3.setRequestTimeout(joinArgs.getRequestTimeout());
        args3.setSynchronous(joinArgs.getSynchronous());
        args3.setOnSuccess((SingleAction)new SingleAction<BindSuccessArgs>(){

            public void invoke(BindSuccessArgs args) {
                try {
                    ClientExtensions.onBindSuccess(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args3.setOnFailure((SingleAction)new SingleAction<BindFailureArgs>(){

            public void invoke(BindFailureArgs args) {
                try {
                    ClientExtensions.onBindFailure(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args3.setDynamicProperties(joinArgs.getDynamicProperties());
        BindArgs bindArgs = args3;
        bindArgs.setDynamicValue(_argsKey, (Object)joinArgs);
        bindArgs.copyExtensions((Extensible)joinArgs);
        client.bind(bindArgs);
        SubscribeArgs args4 = new SubscribeArgs(joinArgs.getChannels(), joinArgs.getTag());
        args4.setRequestUrl(joinArgs.getRequestUrl());
        args4.setRequestTimeout(joinArgs.getRequestTimeout());
        args4.setSynchronous(joinArgs.getSynchronous());
        args4.setOnSuccess((SingleAction)new SingleAction<SubscribeSuccessArgs>(){

            public void invoke(SubscribeSuccessArgs args) {
                try {
                    ClientExtensions.onSubscribeSuccess(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args4.setOnFailure((SingleAction)new SingleAction<SubscribeFailureArgs>(){

            public void invoke(SubscribeFailureArgs args) {
                try {
                    ClientExtensions.onSubscribeFailure(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args4.setOnReceive((SingleAction)new SingleAction<SubscribeReceiveArgs>(){

            public void invoke(SubscribeReceiveArgs args) {
                try {
                    ClientExtensions.onReceive(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args4.setDynamicProperties(joinArgs.getDynamicProperties());
        SubscribeArgs args = args4;
        SubscribeArgsExtensions.setOnClientSubscribe((SubscribeArgs)args, (SingleAction)new SingleAction<ClientSubscribeArgs>(){

            public void invoke(ClientSubscribeArgs args) {
                try {
                    ClientExtensions.onClientSubscribe(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        SubscribeArgsExtensions.setOnClientUnsubscribe((SubscribeArgs)args, (SingleAction)new SingleAction<ClientUnsubscribeArgs>(){

            public void invoke(ClientUnsubscribeArgs args) {
                try {
                    ClientExtensions.onClientUnsubscribe(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args.setDynamicValue(_argsKey, (Object)joinArgs);
        args.copyExtensions((Extensible)joinArgs);
        client.subscribe(args);
        joinArgs.setDynamicValue(_userIdKey, joinArgs.getUserId());
        joinArgs.setDynamicValue(_userNicknameKey, joinArgs.getUserNickname());
        client.endBatch();
        return client;
    }

    public static Client leave(Client client, LeaveArgs leaveArgs) throws Exception {
        if (StringExtensions.isNullOrEmpty((String)leaveArgs.getChannel())) {
            throw new Exception("channel cannot be null.");
        }
        client.startBatch();
        UnsubscribeArgs args3 = new UnsubscribeArgs(leaveArgs.getChannels(), leaveArgs.getTag());
        args3.setRequestUrl(leaveArgs.getRequestUrl());
        args3.setRequestTimeout(leaveArgs.getRequestTimeout());
        args3.setSynchronous(leaveArgs.getSynchronous());
        args3.setOnSuccess((SingleAction)new SingleAction<UnsubscribeSuccessArgs>(){

            public void invoke(UnsubscribeSuccessArgs args) {
                try {
                    ClientExtensions.onUnsubscribeSuccess(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args3.setOnFailure((SingleAction)new SingleAction<UnsubscribeFailureArgs>(){

            public void invoke(UnsubscribeFailureArgs args) {
                try {
                    ClientExtensions.onUnsubscribeFailure(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args3.setDynamicProperties(leaveArgs.getDynamicProperties());
        UnsubscribeArgs unsubscribeArgs = args3;
        unsubscribeArgs.setDynamicValue(_argsKey, (Object)leaveArgs);
        unsubscribeArgs.copyExtensions((Extensible)leaveArgs);
        client.unsubscribe(unsubscribeArgs);
        UnbindArgs args4 = new UnbindArgs(new Record[]{new Record(ClientExtensions.getUserIdKey(leaveArgs.getChannel())), new Record(ClientExtensions.getUserNicknameKey(leaveArgs.getChannel()))});
        args4.setRequestUrl(leaveArgs.getRequestUrl());
        args4.setRequestTimeout(leaveArgs.getRequestTimeout());
        args4.setSynchronous(leaveArgs.getSynchronous());
        args4.setOnSuccess((SingleAction)new SingleAction<UnbindSuccessArgs>(){

            public void invoke(UnbindSuccessArgs args) {
                try {
                    ClientExtensions.onUnbindSuccess(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args4.setOnFailure((SingleAction)new SingleAction<UnbindFailureArgs>(){

            public void invoke(UnbindFailureArgs args) {
                try {
                    ClientExtensions.onUnbindFailure(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args4.setDynamicProperties(leaveArgs.getDynamicProperties());
        UnbindArgs unbindArgs = args4;
        unbindArgs.setDynamicValue(_argsKey, (Object)leaveArgs);
        unbindArgs.copyExtensions((Extensible)leaveArgs);
        client.unbind(unbindArgs);
        client.endBatch();
        return client;
    }

    private static void onBindFailure(BindFailureArgs args) {
        JoinArgs dynamicValue = (JoinArgs)((Object)args.getDynamicValue(_argsKey));
        JoinState state = new JoinState();
        dynamicValue.setDynamicValue(_joinStateKey, state);
        state.updateBindFailure(args);
    }

    private static void onBindSuccess(BindSuccessArgs args) throws Exception {
        JoinArgs dynamicValue = (JoinArgs)((Object)args.getDynamicValue(_argsKey));
        JoinState state = new JoinState();
        dynamicValue.setDynamicValue(_joinStateKey, state);
        state.updateBindSuccess(args);
        dynamicValue.setDynamicValue(_userIdKey, ClientExtensions.getUserIdFromArray(args.getRecords(), dynamicValue.getChannel()));
        dynamicValue.setDynamicValue(_userNicknameKey, ClientExtensions.getUserNicknameFromArray(args.getRecords(), dynamicValue.getChannel()));
    }

    private static void onClientSubscribe(ClientSubscribeArgs args) throws Exception {
        JoinArgs dynamicValue = (JoinArgs)((Object)args.getDynamicValue(_argsKey));
        ClientExtensions.process(SubscriberChangeType.Subscribe, args.getSubscribedClient(), args.getChannel(), dynamicValue, (BaseOutputArgs)args, true);
    }

    private static void onClientUnsubscribe(ClientUnsubscribeArgs args) throws Exception {
        JoinArgs dynamicValue = (JoinArgs)((Object)args.getDynamicValue(_argsKey));
        ClientExtensions.process(SubscriberChangeType.Unsubscribe, args.getUnsubscribedClient(), args.getChannel(), dynamicValue, (BaseOutputArgs)args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onReceive(SubscribeReceiveArgs args) throws Exception {
        JoinArgs dynamicValue = (JoinArgs)((Object)args.getDynamicValue(_argsKey));
        ChatUser user = ClientExtensions.getUser(args.getPublishingClient().getClientId(), args.getPublishingClient().getBoundRecords(), dynamicValue.getChannel());
        if (args.getPublishingClient().getClientId().getHasValue() && user.getUserId() != null) {
            HashMap dictionary = (HashMap)dynamicValue.getDynamicValue(_userCacheKey);
            Object obj2 = dynamicValue.getDynamicValue(_userCacheLockKey);
            if (dictionary != null && obj2 != null) {
                Object object = obj2;
                synchronized (object) {
                    HashMap dictionary2 = null;
                    Holder _var0 = new Holder(dictionary2);
                    boolean _var1 = HashMapExtensions.tryGetValue((HashMap)dictionary, (Object)user.getUserId(), (Holder)_var0);
                    dictionary2 = (HashMap)_var0.getValue();
                    if (!_var1) {
                        dictionary2 = null;
                    }
                    if (dictionary2 != null) {
                        user.loadClientSet(dictionary2);
                    }
                }
            }
        }
        JoinReceiveArgs args4 = new JoinReceiveArgs(args.getChannel(), args.getDataJson(), args.getDataBytes(), args.getConnectionType(), args.getReconnectAfter());
        args4.__publishingUser = user;
        args4.__userId = (String)dynamicValue.getDynamicValue(_userIdKey);
        args4.__userNickname = (String)dynamicValue.getDynamicValue(_userNicknameKey);
        args4.setClient(args.getClient());
        args4.setTimestamp(args.getTimestamp());
        args4.setDynamicProperties(dynamicValue.getDynamicProperties());
        JoinReceiveArgs p = args4;
        p.copyExtensions((Extensible)args);
        dynamicValue.getOnReceive().invoke((Object)p);
    }

    private static void onSubscribeFailure(SubscribeFailureArgs args) throws Exception {
        JoinArgs dynamicValue = (JoinArgs)((Object)args.getDynamicValue(_argsKey));
        JoinState state = (JoinState)dynamicValue.getDynamicValue(_joinStateKey);
        dynamicValue.unsetDynamicValue(_joinStateKey);
        state.updateSubscribeFailure(args);
        if (state.getBindSuccess()) {
            ClientExtensions.raiseJoinFailure(dynamicValue, (BaseOutputArgs)args, args.getRetry(), args.getIsResubscribe(), args.getChannels(), new Exception(StringExtensions.format((String)"Join failed (bind succeeded, but subscribe failed [{0}]).", (Object)args.getException().getMessage())));
        } else {
            ClientExtensions.raiseJoinFailure(dynamicValue, (BaseOutputArgs)args, args.getRetry(), args.getIsResubscribe(), args.getChannels(), new Exception(StringExtensions.format((String)"Join failed (bind failed [{0}] and subscribe failed [{1}]).", (Object)state.getBindFailureArgs().getException().getMessage(), (Object)args.getException().getMessage())));
        }
    }

    private static void onSubscribeSuccess(SubscribeSuccessArgs args) throws Exception {
        JoinArgs dynamicValue = (JoinArgs)((Object)args.getDynamicValue(_argsKey));
        JoinState state = (JoinState)dynamicValue.getDynamicValue(_joinStateKey);
        dynamicValue.unsetDynamicValue(_joinStateKey);
        state.updateSubscribeSuccess(args);
        dynamicValue.setDynamicValue(_userCacheKey, new HashMap());
        dynamicValue.setDynamicValue(_userCacheLockKey, new Object());
        if (!state.getBindSuccess()) {
            ClientExtensions.raiseJoinFailure(dynamicValue, (BaseOutputArgs)state.getBindFailureArgs(), state.getBindFailureArgs().getRetry(), args.getIsResubscribe(), args.getChannels(), new Exception(StringExtensions.format((String)"Join failed (subscribe succeeded, but bind failed [{0}]).", (Object)state.getBindFailureArgs().getException().getMessage())));
        } else {
            SubscribedClient[] clientArray = null;
            try {
                clientArray = (SubscribedClient[])HashMapExtensions.getItem((HashMap)SubscribeSuccessArgsExtensions.getSubscribedClients((SubscribeSuccessArgs)args)).get(args.getChannel());
            }
            catch (Exception exception) {
                ClientExtensions.raiseJoinFailure(dynamicValue, (BaseOutputArgs)args, false, args.getIsResubscribe(), args.getChannels(), exception);
                return;
            }
            HashMap dictionary = new HashMap();
            for (SubscribedClient client : clientArray) {
                ChatUser user = ClientExtensions.process(SubscriberChangeType.Subscribe, client, args.getChannel(), dynamicValue, (BaseOutputArgs)args, false);
                if (user == null) continue;
                HashMapExtensions.getItem(dictionary).put(user.getUserId(), user);
            }
            ArrayList<ChatUser> users = new ArrayList<ChatUser>();
            for (ChatUser user : HashMapExtensions.getValues(dictionary)) {
                users.add(user);
            }
            ClientExtensions.raiseJoinSuccess(dynamicValue, args, users);
        }
    }

    private static void onUnbindFailure(UnbindFailureArgs args) throws Exception {
        LeaveArgs dynamicValue = (LeaveArgs)((Object)args.getDynamicValue(_argsKey));
        LeaveState state = (LeaveState)dynamicValue.getDynamicValue(_leaveStateKey);
        dynamicValue.unsetDynamicValue(_leaveStateKey);
        state.updateUnbindFailure(args);
        if (state.getUnsubscribeSuccess()) {
            ClientExtensions.raiseLeaveFailure(dynamicValue, (BaseFailureArgs)args, state.getUnsubscribeSuccessArgs().getChannels(), new Exception(StringExtensions.format((String)"Leave failed (unsubscribe succeeded, but unbind failed [{0}]).", (Object)args.getException().getMessage())));
        } else {
            ClientExtensions.raiseLeaveFailure(dynamicValue, (BaseFailureArgs)args, state.getUnsubscribeFailureArgs().getChannels(), new Exception(StringExtensions.format((String)"Leave failed (unsubscribe failed [{0}] and unbind failed [{1}]).", (Object)state.getUnsubscribeFailureArgs().getException().getMessage(), (Object)args.getException().getMessage())));
        }
    }

    private static void onUnbindSuccess(UnbindSuccessArgs args) throws Exception {
        LeaveArgs dynamicValue = (LeaveArgs)((Object)args.getDynamicValue(_argsKey));
        LeaveState state = (LeaveState)dynamicValue.getDynamicValue(_leaveStateKey);
        dynamicValue.unsetDynamicValue(_leaveStateKey);
        state.updateUnbindSuccess(args);
        dynamicValue.setDynamicValue(_userIdKey, ClientExtensions.getUserIdFromArray(args.getRecords(), dynamicValue.getChannel()));
        dynamicValue.setDynamicValue(_userNicknameKey, ClientExtensions.getUserNicknameFromArray(args.getRecords(), dynamicValue.getChannel()));
        if (!state.getUnsubscribeSuccess()) {
            ClientExtensions.raiseLeaveFailure(dynamicValue, (BaseFailureArgs)state.getUnsubscribeFailureArgs(), state.getUnsubscribeFailureArgs().getChannels(), new Exception(StringExtensions.format((String)"Leave failed (unbind succeeded, but unsubscribe failed [{0}]).", (Object)state.getUnsubscribeFailureArgs().getException().getMessage())));
        } else {
            ClientExtensions.raiseLeaveSuccess(dynamicValue, state.getUnsubscribeSuccessArgs());
        }
    }

    private static void onUnsubscribeFailure(UnsubscribeFailureArgs args) {
        LeaveArgs dynamicValue = (LeaveArgs)((Object)args.getDynamicValue(_argsKey));
        LeaveState state = new LeaveState();
        dynamicValue.setDynamicValue(_leaveStateKey, state);
        state.updateUnsubscribeFailure(args);
    }

    private static void onUnsubscribeSuccess(UnsubscribeSuccessArgs args) {
        LeaveArgs dynamicValue = (LeaveArgs)((Object)args.getDynamicValue(_argsKey));
        LeaveState state = new LeaveState();
        dynamicValue.setDynamicValue(_leaveStateKey, state);
        state.updateUnsubscribeSuccess(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChatUser process(SubscriberChangeType type, SubscribedClient subscriber, String channel, JoinArgs joinArgs, BaseOutputArgs outputArgs, boolean fireEvents) throws Exception {
        SingleAction<UserClientLeaveArgs> onUserClientLeave;
        Object obj3;
        HashMap dynamicValue = (HashMap)joinArgs.getDynamicValue(_userCacheKey);
        Object obj2 = joinArgs.getDynamicValue(_userCacheLockKey);
        if (dynamicValue == null || obj2 == null) {
            return null;
        }
        ChatUser user = ClientExtensions.getUser(new NullableGuid(subscriber.getClientId()), subscriber.getBoundRecords(), joinArgs.getChannel());
        if (user.getUserId() == null) {
            if (Global.equals((Object)type, (Object)SubscriberChangeType.Subscribe)) {
                Log.warn((String)"A remote client subscribed but a user ID was not bound. Is the remote client using the Chat extension, or did they leave multiple times?");
            } else {
                Log.warn((String)"A remote client unsubscribed but a user ID was not bound. Is the remote client using the Chat extension, or did they leave multiple times?");
            }
            return null;
        }
        if (Global.equals((Object)user.getUserId(), (Object)((String)joinArgs.getDynamicValue(_userIdKey)))) {
            return null;
        }
        if (Global.equals((Object)type, (Object)SubscriberChangeType.Subscribe)) {
            SingleAction<UserClientJoinArgs> onUserClientJoin;
            Object obj32;
            boolean flag = false;
            Object object = obj32 = obj2;
            synchronized (object) {
                HashMap<String, HashMap<String, Record>> dictionary2 = null;
                Holder _var0 = new Holder(dictionary2);
                boolean _var1 = HashMapExtensions.tryGetValue((HashMap)dynamicValue, (Object)user.getUserId(), (Holder)_var0);
                dictionary2 = (HashMap<String, HashMap<String, Record>>)_var0.getValue();
                if (!_var1) {
                    dictionary2 = new HashMap<String, HashMap<String, Record>>();
                }
                HashMapExtensions.getItem((HashMap)dictionary2).put(subscriber.getClientId().toString(), subscriber.getBoundRecords());
                flag = HashMapExtensions.getCount(dictionary2) == 1;
                user.loadClientSet(dictionary2);
                if (flag) {
                    HashMapExtensions.getItem((HashMap)dynamicValue).put(user.getUserId(), dictionary2);
                }
            }
            if (flag) {
                SingleAction<UserJoinArgs> onUserJoin = joinArgs.getOnUserJoin();
                if (fireEvents && onUserJoin != null) {
                    UserJoinArgs args2 = new UserJoinArgs(channel, subscriber);
                    args2.__joinedUser = user;
                    args2.__userId = (String)joinArgs.getDynamicValue(_userIdKey);
                    args2.__userNickname = (String)joinArgs.getDynamicValue(_userNicknameKey);
                    args2.setClient(outputArgs.getClient());
                    args2.setTimestamp(outputArgs.getTimestamp());
                    args2.setDynamicProperties(outputArgs.getDynamicProperties());
                    UserJoinArgs p = args2;
                    p.copyExtensions((Extensible)outputArgs);
                    onUserJoin.invoke((Object)p);
                }
            }
            if (fireEvents && (onUserClientJoin = joinArgs.getOnUserClientJoin()) != null) {
                UserClientJoinArgs args4 = new UserClientJoinArgs(channel, subscriber);
                args4.__joinedUser = user;
                args4.__userId = (String)joinArgs.getDynamicValue(_userIdKey);
                args4.__userNickname = (String)joinArgs.getDynamicValue(_userNicknameKey);
                args4.setClient(outputArgs.getClient());
                args4.setTimestamp(outputArgs.getTimestamp());
                args4.setDynamicProperties(outputArgs.getDynamicProperties());
                UserClientJoinArgs args3 = args4;
                args3.copyExtensions((Extensible)outputArgs);
                onUserClientJoin.invoke((Object)args3);
            }
            return user;
        }
        boolean flag2 = false;
        Object onUserClientJoin = obj3 = obj2;
        synchronized (onUserClientJoin) {
            HashMap dictionary2 = null;
            Holder _var2 = new Holder(dictionary2);
            boolean _var3 = HashMapExtensions.tryGetValue((HashMap)dynamicValue, (Object)user.getUserId(), (Holder)_var2);
            dictionary2 = (HashMap)_var2.getValue();
            if (!_var3) {
                Log.debug((String)"Unsubscribe notification received, but no user associated with the client ID was found.");
                return null;
            }
            user.loadClientSet(dictionary2);
            HashMapExtensions.remove((HashMap)dictionary2, (Object)subscriber.getClientId().toString());
            boolean bl = flag2 = HashMapExtensions.getCount((HashMap)dictionary2) == 0;
            if (flag2) {
                HashMapExtensions.remove((HashMap)dynamicValue, (Object)user.getUserId());
            }
        }
        if (fireEvents && (onUserClientLeave = joinArgs.getOnUserClientLeave()) != null) {
            UserClientLeaveArgs args6 = new UserClientLeaveArgs(channel, subscriber);
            args6.__leftUser = user;
            args6.__userId = (String)joinArgs.getDynamicValue(_userIdKey);
            args6.__userNickname = (String)joinArgs.getDynamicValue(_userNicknameKey);
            args6.setClient(outputArgs.getClient());
            args6.setTimestamp(outputArgs.getTimestamp());
            args6.setDynamicProperties(outputArgs.getDynamicProperties());
            UserClientLeaveArgs args5 = args6;
            args5.copyExtensions((Extensible)outputArgs);
            onUserClientLeave.invoke((Object)args5);
        }
        if (flag2) {
            SingleAction<UserLeaveArgs> onUserLeave = joinArgs.getOnUserLeave();
            if (fireEvents && onUserLeave != null) {
                UserLeaveArgs args8 = new UserLeaveArgs(channel, subscriber);
                args8.__leftUser = user;
                args8.__userId = (String)joinArgs.getDynamicValue(_userIdKey);
                args8.__userNickname = (String)joinArgs.getDynamicValue(_userNicknameKey);
                args8.setClient(outputArgs.getClient());
                args8.setTimestamp(outputArgs.getTimestamp());
                args8.setDynamicProperties(outputArgs.getDynamicProperties());
                UserLeaveArgs args7 = args8;
                args7.copyExtensions((Extensible)outputArgs);
                onUserLeave.invoke((Object)args7);
            }
        }
        return user;
    }

    private static void raiseJoinFailure(JoinArgs joinArgs, BaseOutputArgs args, boolean retry, boolean isRejoin, String[] channels, Exception exception) throws Exception {
        block8: {
            SingleAction<JoinCompleteArgs> onComplete;
            Exception exception2;
            SingleAction<JoinFailureArgs> onFailure = joinArgs.getOnFailure();
            if (onFailure != null) {
                JoinFailureArgs p;
                block7: {
                    JoinFailureArgs args3 = new JoinFailureArgs();
                    args3.__channels = channels;
                    args3.__userId = (String)joinArgs.getDynamicValue(_userIdKey);
                    args3.__userNickname = (String)joinArgs.getDynamicValue(_userNicknameKey);
                    args3.__isRejoin = isRejoin;
                    args3.setRetry(retry);
                    args3.setClient(args.getClient());
                    args3.setException(exception);
                    args3.setTimestamp(args.getTimestamp());
                    args3.setDynamicProperties(joinArgs.getDynamicProperties());
                    p = args3;
                    p.copyExtensions((Extensible)args);
                    try {
                        onFailure.invoke((Object)p);
                    }
                    catch (Exception exception1) {
                        exception2 = exception1;
                        if (args.getClient().raiseUnhandledException(exception2)) break block7;
                        AsyncException.asyncThrow((Exception)exception2, (String)"Client -> Join -> OnFailure");
                    }
                }
                retry = p.getRetry();
            }
            if ((onComplete = joinArgs.getOnComplete()) != null) {
                JoinCompleteArgs args5 = new JoinCompleteArgs();
                args5.__isRejoin = isRejoin;
                args5.setClient(args.getClient());
                args5.setTimestamp(args.getTimestamp());
                args5.setDynamicProperties(joinArgs.getDynamicProperties());
                JoinCompleteArgs args4 = args5;
                args4.copyExtensions((Extensible)args);
                try {
                    onComplete.invoke((Object)args4);
                }
                catch (Exception exception3) {
                    exception2 = exception3;
                    if (args.getClient().raiseUnhandledException(exception2)) break block8;
                    AsyncException.asyncThrow((Exception)exception2, (String)"Client -> Join -> OnComplete");
                }
            }
        }
        if (retry) {
            joinArgs.setIsRetry(true);
            ClientExtensions.join(args.getClient(), joinArgs);
        }
    }

    private static void raiseJoinSuccess(JoinArgs joinArgs, SubscribeSuccessArgs args, ArrayList<ChatUser> users) throws Exception {
        block7: {
            SingleAction<JoinCompleteArgs> onComplete;
            Exception exception;
            block6: {
                SingleAction<JoinSuccessArgs> onSuccess = joinArgs.getOnSuccess();
                if (onSuccess != null) {
                    JoinSuccessArgs args3 = new JoinSuccessArgs();
                    args3.__channels = args.getChannels();
                    args3.__userId = (String)joinArgs.getDynamicValue(_userIdKey);
                    args3.__userNickname = (String)joinArgs.getDynamicValue(_userNicknameKey);
                    args3.__users = users.toArray(new ChatUser[0]);
                    args3.__isRejoin = args.getIsResubscribe();
                    args3.setClient(args.getClient());
                    args3.setTimestamp(args.getTimestamp());
                    args3.setDynamicProperties(joinArgs.getDynamicProperties());
                    JoinSuccessArgs p = args3;
                    p.copyExtensions((Extensible)args);
                    try {
                        onSuccess.invoke((Object)p);
                    }
                    catch (Exception exception1) {
                        exception = exception1;
                        if (args.getClient().raiseUnhandledException(exception)) break block6;
                        AsyncException.asyncThrow((Exception)exception, (String)"Client -> Join -> OnSuccess");
                    }
                }
            }
            if ((onComplete = joinArgs.getOnComplete()) != null) {
                JoinCompleteArgs args5 = new JoinCompleteArgs();
                args5.__isRejoin = args.getIsResubscribe();
                args5.setClient(args.getClient());
                args5.setTimestamp(args.getTimestamp());
                args5.setDynamicProperties(joinArgs.getDynamicProperties());
                JoinCompleteArgs args4 = args5;
                args4.copyExtensions((Extensible)args);
                try {
                    onComplete.invoke((Object)args4);
                }
                catch (Exception exception2) {
                    exception = exception2;
                    if (args.getClient().raiseUnhandledException(exception)) break block7;
                    AsyncException.asyncThrow((Exception)exception, (String)"Client -> Join -> OnComplete");
                }
            }
        }
    }

    private static void raiseLeaveFailure(LeaveArgs leaveArgs, BaseFailureArgs args, String[] channels, Exception exception) throws Exception {
        boolean retry;
        block8: {
            SingleAction<LeaveCompleteArgs> onComplete;
            Exception exception2;
            retry = false;
            SingleAction<LeaveFailureArgs> onFailure = leaveArgs.getOnFailure();
            if (onFailure != null) {
                LeaveFailureArgs p;
                block7: {
                    LeaveFailureArgs args3 = new LeaveFailureArgs();
                    args3.__channels = channels;
                    args3.__userId = (String)Global.tryCast((Object)leaveArgs.getDynamicValue(_userIdKey), String.class);
                    args3.__userNickname = (String)Global.tryCast((Object)leaveArgs.getDynamicValue(_userNicknameKey), String.class);
                    args3.setRetry(args.getRetry());
                    args3.setClient(args.getClient());
                    args3.setException(exception);
                    args3.setTimestamp(args.getTimestamp());
                    args3.setDynamicProperties(leaveArgs.getDynamicProperties());
                    p = args3;
                    p.copyExtensions((Extensible)args);
                    try {
                        onFailure.invoke((Object)p);
                    }
                    catch (Exception exception1) {
                        exception2 = exception1;
                        if (args.getClient().raiseUnhandledException(exception2)) break block7;
                        AsyncException.asyncThrow((Exception)exception2, (String)"Client -> Leave -> OnFailure");
                    }
                }
                retry = p.getRetry();
            }
            if ((onComplete = leaveArgs.getOnComplete()) != null) {
                LeaveCompleteArgs args5 = new LeaveCompleteArgs();
                args5.setClient(args.getClient());
                args5.setTimestamp(args.getTimestamp());
                args5.setDynamicProperties(leaveArgs.getDynamicProperties());
                LeaveCompleteArgs args4 = args5;
                args4.copyExtensions((Extensible)args);
                try {
                    onComplete.invoke((Object)args4);
                }
                catch (Exception exception3) {
                    exception2 = exception3;
                    if (args.getClient().raiseUnhandledException(exception2)) break block8;
                    AsyncException.asyncThrow((Exception)exception2, (String)"Client -> Leave -> OnComplete");
                }
            }
        }
        if (retry) {
            leaveArgs.setIsRetry(true);
            ClientExtensions.leave(args.getClient(), leaveArgs);
        }
    }

    private static void raiseLeaveSuccess(LeaveArgs leaveArgs, UnsubscribeSuccessArgs args) throws Exception {
        block7: {
            SingleAction<LeaveCompleteArgs> onComplete;
            Exception exception;
            block6: {
                SingleAction<LeaveSuccessArgs> onSuccess = leaveArgs.getOnSuccess();
                if (onSuccess != null) {
                    LeaveSuccessArgs args3 = new LeaveSuccessArgs();
                    args3.__channels = args.getChannels();
                    args3.__userId = (String)leaveArgs.getDynamicValue(_userIdKey);
                    args3.__userNickname = (String)leaveArgs.getDynamicValue(_userNicknameKey);
                    args3.setClient(args.getClient());
                    args3.setTimestamp(args.getTimestamp());
                    args3.setDynamicProperties(leaveArgs.getDynamicProperties());
                    LeaveSuccessArgs p = args3;
                    p.copyExtensions((Extensible)args);
                    try {
                        onSuccess.invoke((Object)p);
                    }
                    catch (Exception exception1) {
                        exception = exception1;
                        if (args.getClient().raiseUnhandledException(exception)) break block6;
                        AsyncException.asyncThrow((Exception)exception, (String)"Client -> Leave -> OnSuccess");
                    }
                }
            }
            if ((onComplete = leaveArgs.getOnComplete()) != null) {
                LeaveCompleteArgs args5 = new LeaveCompleteArgs();
                args5.setClient(args.getClient());
                args5.setTimestamp(args.getTimestamp());
                args5.setDynamicProperties(leaveArgs.getDynamicProperties());
                LeaveCompleteArgs args4 = args5;
                args4.copyExtensions((Extensible)args);
                try {
                    onComplete.invoke((Object)args4);
                }
                catch (Exception exception2) {
                    exception = exception2;
                    if (args.getClient().raiseUnhandledException(exception)) break block7;
                    AsyncException.asyncThrow((Exception)exception, (String)"Client -> Leave -> OnComplete");
                }
            }
        }
    }

    static {
        _userIdKey = "fm.chat.userId";
        _userNicknameKey = "fm.chat.userNickname";
        _userCacheKey = "fm.chat.userCache";
        _userCacheLockKey = "fm.chat.userCacheLock";
        _joinStateKey = "fm.chat.joinState";
        _leaveStateKey = "fm.chat.leaveState";
        _argsKey = "fm.chat.args";
    }
}

