/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import fm.icelink.IAction0;
import fm.icelink.IVideoSource;
import fm.icelink.LayoutFrame;
import fm.icelink.LayoutScale;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.ViewSink;
import fm.icelink.android.OpenGLView;
import fm.icelink.android.Utility;

public class OpenGLSink
extends ViewSink<FrameLayout> {
    private OpenGLView _view;
    private FrameLayout _viewContainer;
    int lastContainerWidth = 0;
    int lastContainerHeight = 0;
    int lastFrameWidth = 0;
    int lastFrameHeight = 0;

    public FrameLayout getView() {
        return this._viewContainer;
    }

    public LayoutScale getViewScale() {
        return this._view.getScale();
    }

    public void setViewScale(LayoutScale viewScale) {
        if (viewScale != this._view.getScale()) {
            throw new RuntimeException("View scale can not be changed.");
        }
    }

    public boolean getViewMirror() {
        return false;
    }

    public void setViewMirror(boolean viewMirror) {
        throw new RuntimeException("View mirroring is not currently supported.");
    }

    public String getLabel() {
        return "Android OpenGL Sink";
    }

    public OpenGLSink(Context context) {
        this(context, LayoutScale.Contain);
    }

    public OpenGLSink(Context context, IVideoSource source) {
        this(context, LayoutScale.Contain, source);
    }

    public OpenGLSink(Context context, IVideoSource[] sources) {
        this(context, LayoutScale.Contain, sources);
    }

    public OpenGLSink(Context context, LayoutScale viewScale) {
        super(VideoFormat.getI420());
        this.initialize(context, viewScale);
    }

    public OpenGLSink(Context context, LayoutScale viewScale, IVideoSource source) {
        super(source);
        this.initialize(context, viewScale);
    }

    public OpenGLSink(Context context, LayoutScale viewScale, IVideoSource[] sources) {
        super(sources);
        this.initialize(context, viewScale);
    }

    public OpenGLSink(OpenGLView view) {
        super(VideoFormat.getI420());
        this.initialize(view);
    }

    public OpenGLSink(OpenGLView view, IVideoSource source) {
        super(source);
        this.initialize(view);
    }

    public OpenGLSink(OpenGLView view, IVideoSource[] sources) {
        super(sources);
        this.initialize(view);
    }

    private void initialize(final Context context, final LayoutScale viewScale) {
        Utility.dispatchToMainThread(new IAction0(){

            public void invoke() {
                OpenGLSink.this.initialize(new OpenGLView(context.getApplicationContext(), viewScale));
            }
        }, true);
    }

    private void initialize(final OpenGLView view) {
        if (!((VideoFormat)this.getInputFormat()).getName().equals(VideoFormat.getI420Name())) {
            throw new RuntimeException("Input format must be I420.");
        }
        if (view == null) {
            throw new RuntimeException("View cannot be null.");
        }
        Utility.dispatchToMainThread(new IAction0(){

            public void invoke() {
                OpenGLSink.this._view = view;
                OpenGLSink.this._viewContainer = new FrameLayout(view.getContext());
                FrameLayout.LayoutParams lp = OpenGLSink.this._view.getScale() == LayoutScale.Contain ? new FrameLayout.LayoutParams(0, 0) : new FrameLayout.LayoutParams(-1, -1);
                OpenGLSink.this._viewContainer.addView((View)OpenGLSink.this._view, (ViewGroup.LayoutParams)lp);
            }
        }, true);
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        super.doProcessFrame(frame, inputBuffer);
        this.renderBuffer(inputBuffer);
    }

    public void renderBuffer(VideoBuffer buffer) {
        LayoutScale viewScale = this.getViewScale();
        if (viewScale == LayoutScale.Contain) {
            int containerWidth = this._viewContainer.getWidth();
            int containerHeight = this._viewContainer.getHeight();
            int frameWidth = buffer.getWidth();
            int frameHeight = buffer.getHeight();
            if (containerWidth > 0 && containerHeight > 0 && frameWidth > 0 && frameHeight > 0 && (containerWidth != this.lastContainerWidth || containerHeight != this.lastContainerHeight || frameWidth != this.lastFrameWidth || frameHeight != this.lastFrameHeight)) {
                this.lastContainerWidth = containerWidth;
                this.lastContainerHeight = containerHeight;
                this.lastFrameWidth = frameWidth;
                this.lastFrameHeight = frameHeight;
                LayoutFrame frame = LayoutFrame.getScaledFrame((LayoutScale)viewScale, (int)containerWidth, (int)containerHeight, (int)frameWidth, (int)frameHeight);
                final FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this._view.getLayoutParams();
                lp.width = frame.getWidth();
                lp.height = frame.getHeight();
                lp.leftMargin = frame.getX();
                lp.topMargin = frame.getY();
                Utility.dispatchToMainThread(new IAction0(){

                    public void invoke() {
                        OpenGLSink.this._view.setLayoutParams((ViewGroup.LayoutParams)lp);
                    }
                }, true);
            }
        }
        this._view.render(buffer);
    }
}

