/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import fm.icelink.DataBuffer;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IVideoSource;
import fm.icelink.Log;
import fm.icelink.ManagedCondition;
import fm.icelink.ManagedThread;
import fm.icelink.MediaFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoDecoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.android.MediaCodecUtility;
import java.nio.ByteBuffer;

public class MediaCodecDecoder
extends VideoDecoder {
    private MediaCodec _decoder;
    private String _mimeType;
    private int _currentWidth;
    private int _currentHeight;
    private int _currentStride;
    private int _currentSliceHeight;
    private MediaCodecInfo _decoderInfo;
    private int _colorFormat;
    private boolean _needsKeyFrame;
    private volatile boolean _decoding = false;
    private Object _stateLock = new Object();
    private ManagedThread _thread;
    private ManagedCondition _condition;
    private static final int infinite = -1;
    private MediaCodec.BufferInfo outputBufferInfo = new MediaCodec.BufferInfo();
    private static final int QOMX_COLOR_FormatYUV420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int QCOM_TILE_WIDTH = 64;
    private static final int QCOM_TILE_HEIGHT = 32;
    private static final int QCOM_TILE_SIZE = 2048;
    private static final int QCOM_TILE_GROUP_SIZE = 8192;

    public void setNeedsKeyFrame() {
        this._needsKeyFrame = true;
    }

    public boolean getNeedsKeyFrame() {
        return this._needsKeyFrame;
    }

    public String getLabel() {
        return "MediaCodecDecoder";
    }

    public MediaCodecDecoder(MediaCodecInfo decoderInfo, VideoFormat inputFormat, VideoFormat outputFormat) {
        super(inputFormat, outputFormat);
        this.initialize(decoderInfo, inputFormat, outputFormat);
    }

    public MediaCodecDecoder(MediaCodecInfo decoderInfo, IVideoSource source, VideoFormat outputFormat) {
        super((VideoFormat)source.getOutputFormat(), outputFormat);
        this.initialize(decoderInfo, (VideoFormat)source.getOutputFormat(), outputFormat);
    }

    private void initialize(MediaCodecInfo decoderInfo, VideoFormat inputFormat, VideoFormat outputFormat) {
        if (Build.VERSION.SDK_INT < 19) {
            throw new RuntimeException("Android 4.4 or higher is required to use hardware encoding.");
        }
        this._currentWidth = 640;
        this._currentHeight = 480;
        this._currentStride = 0;
        this._currentSliceHeight = 0;
        this._decoderInfo = decoderInfo;
        if (this._decoderInfo.isEncoder()) {
            throw new RuntimeException("decoderInfo is not a valid encoder");
        }
        this._mimeType = MediaCodecUtility.getMimeType(inputFormat);
        if (this._mimeType == null) {
            throw new RuntimeException("Invalid input format " + inputFormat.getName());
        }
        if (!MediaCodecUtility.hasMimeType(this._decoderInfo, this._mimeType)) {
            throw new RuntimeException("Invalid input format " + inputFormat.getName() + " and respective mime type " + this._mimeType + " for this decoderInfo");
        }
        this._colorFormat = MediaCodecUtility.getColorFormat(outputFormat);
        if (this._colorFormat < 0 || !MediaCodecUtility.hasColorFormat(this._decoderInfo, this._mimeType, this._colorFormat)) {
            throw new RuntimeException("Invalid output format " + outputFormat.getName());
        }
        this._decoding = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDestroy() {
        Object object = this._stateLock;
        synchronized (object) {
            this._decoding = false;
            this._condition.pulse();
        }
        if (this._decoder != null) {
            this._decoder.stop();
            this._decoder.release();
            this._decoder = null;
        }
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer buffer) {
        this.decode(buffer);
    }

    protected boolean isKeyFrame(DataBuffer dataBuffer) {
        return true;
    }

    private void initializeMediaCodec() throws Exception {
        MediaFormat format = MediaFormat.createVideoFormat((String)this._mimeType, (int)this._currentWidth, (int)this._currentHeight);
        format.setInteger("color-format", this._colorFormat);
        this._decoder = MediaCodec.createByCodecName((String)this._decoderInfo.getName());
        this._decoder.configure(format, null, null, 0);
        this._condition = new ManagedCondition();
        this._thread = new ManagedThread((IAction1)new IActionDelegate1<ManagedThread>(){

            public String getId() {
                return "fm.icelink.android.MediaCodecDecoder.loop";
            }

            public void invoke(ManagedThread thread) {
                MediaCodecDecoder.this.loop(thread);
            }
        });
        this._decoder.start();
        this._thread.start();
    }

    public void decode(VideoBuffer inputBuffer) {
        try {
            DataBuffer[] buffers;
            if (this._decoder == null) {
                this.initializeMediaCodec();
            }
            if ((buffers = inputBuffer.getDataBuffers()).length > 1) {
                Log.error((String)"VideoBuffer must contain a single plane packed with all planes of the given video format.");
            }
            this.queueEncodedFrame(buffers[0]);
        }
        catch (Exception e) {
            if (this._decoder != null) {
                this._decoder.stop();
                this._decoder.release();
                this._decoder = null;
            }
            Log.error((String)("MediaCodec decode failed for " + this._mimeType + "\n" + e.getMessage()));
        }
    }

    @SuppressLint(value={"NewApi"})
    private void queueEncodedFrame(DataBuffer encodedFrame) {
        int inputBufferIndex = -1;
        while (inputBufferIndex < 0) {
            inputBufferIndex = this._decoder.dequeueInputBuffer(-1L);
        }
        ByteBuffer inputBuffer = Build.VERSION.SDK_INT < 21 ? this._decoder.getInputBuffers()[inputBufferIndex] : this._decoder.getInputBuffer(inputBufferIndex);
        inputBuffer.position(0);
        inputBuffer.limit(encodedFrame.getLength());
        inputBuffer.put(encodedFrame.toArray());
        inputBuffer.position(0);
        this._decoder.queueInputBuffer(inputBufferIndex, 0, encodedFrame.getLength(), 0L, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void loop(ManagedThread thread) {
        while (this._decoding) {
            thread.loopBegin();
            DataBuffer buffer = null;
            int outputBufferIndex = this._decoder.dequeueOutputBuffer(this.outputBufferInfo, 0L);
            if (outputBufferIndex >= 0) {
                int sliceHeight;
                ByteBuffer outputBuffer = Build.VERSION.SDK_INT < 21 ? this._decoder.getOutputBuffers()[outputBufferIndex] : this._decoder.getOutputBuffer(outputBufferIndex);
                outputBuffer.position(this.outputBufferInfo.offset);
                outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
                boolean frameOffset = false;
                int stride = this._currentStride > 0 ? this._currentStride : (int)((double)this.outputBufferInfo.size / (1.5 * (double)this._currentWidth));
                int n = sliceHeight = this._currentSliceHeight > 0 ? this._currentSliceHeight : this._currentHeight;
                if (this._colorFormat == 2141391875) {
                    int frameLength = this.outputBufferInfo.size;
                    if (buffer == null || buffer.getLength() != frameLength) {
                        buffer = DataBuffer.allocate((int)this.outputBufferInfo.size);
                    }
                }
                this._decoder.releaseOutputBuffer(outputBufferIndex, false);
                if (this._colorFormat == 2141391875) {
                    int convertedBufferLength = (int)((double)(this._currentWidth * this._currentHeight) * 1.5);
                    DataBuffer convertedBuffer = DataBuffer.allocate((int)convertedBufferLength);
                    this.convertQcomYuv420PackedSemiPlanar64x32Tile2m8kaToYuv420PackedSemiPlanar(buffer, convertedBuffer, this._currentWidth, this._currentHeight, stride, true);
                    buffer = convertedBuffer;
                }
                VideoFrame frame = new VideoFrame(new VideoBuffer(this._currentWidth, this._currentHeight, buffer, (VideoFormat)this.getOutputFormat()));
                this.raiseFrame((MediaFrame)frame);
            } else if (outputBufferIndex == -2) {
                MediaFormat outputFormat = this._decoder.getOutputFormat();
                this._currentWidth = outputFormat.getInteger("width");
                this._currentHeight = outputFormat.getInteger("height");
                this._currentStride = outputFormat.getInteger("stride");
                this._currentSliceHeight = outputFormat.getInteger("slice-height");
                int colorFormat = outputFormat.getInteger("color-format");
                if (colorFormat != this._colorFormat) {
                    if (colorFormat == 2141391875) {
                        Log.warn((String)("Unexpected color format: " + colorFormat + ". Format will be converted."));
                    } else {
                        Log.error((String)("Unexpected color format: " + colorFormat + ". Output may be incorrect."));
                    }
                }
                this._colorFormat = colorFormat;
            } else {
                if (outputBufferIndex == -1) {
                    ManagedCondition managedCondition = this._condition;
                    synchronized (managedCondition) {
                        this._condition.halt(1);
                    }
                }
                this._needsKeyFrame = true;
            }
            thread.loopEnd();
        }
    }

    private void convertQcomYuv420PackedSemiPlanar64x32Tile2m8kaToYuv420PackedSemiPlanar(DataBuffer src, DataBuffer dst, int width, int height, int stride, boolean deinterleave) {
        int pixelCount;
        int tile_w = (width - 1) / 64 + 1;
        int tile_w_align = tile_w + 1 & 0xFFFFFFFE;
        int tile_h_luma = (height - 1) / 32 + 1;
        int tile_h_chroma = (height / 2 - 1) / 32 + 1;
        int src_luma_size = tile_w_align * tile_h_luma * 2048;
        if (src_luma_size % 8192 != 0) {
            src_luma_size = ((src_luma_size - 1) / 8192 + 1) * 8192;
        }
        int uOffset = pixelCount = width * height;
        int vOffset = pixelCount + pixelCount / 4;
        for (int y = 0; y < tile_h_luma; ++y) {
            int row_width = width;
            for (int x = 0; x < tile_w; ++x) {
                int tile_height;
                int tile_width;
                int src_luma_idx = MediaCodecDecoder.getQcomTilePosition(x, y, tile_w_align, tile_h_luma) * 2048;
                int src_chroma_idx = src_luma_size + MediaCodecDecoder.getQcomTilePosition(x, y / 2, tile_w_align, tile_h_chroma) * 2048;
                if ((y & 1) != 0) {
                    src_chroma_idx += 1024;
                }
                if ((tile_width = row_width) > 64) {
                    tile_width = 64;
                }
                if ((tile_height = height) > 32) {
                    tile_height = 32;
                }
                int dst_luma_idx = y * 32 * stride + x * 64;
                int dst_chroma_idx = pixelCount + dst_luma_idx / stride * stride / 2 + dst_luma_idx % stride;
                tile_height /= 2;
                while (tile_height-- > 0) {
                    dst.write(src.subset(src_luma_idx, tile_width), dst_luma_idx);
                    dst.write(src.subset(src_luma_idx += 64, tile_width), dst_luma_idx += stride);
                    src_luma_idx += 64;
                    dst_luma_idx += stride;
                    if (deinterleave) {
                        int offset = (dst_chroma_idx - pixelCount) / 2;
                        for (int i = 0; i < tile_width; i += 2) {
                            dst.write16(src.read16(src_chroma_idx + i + 0), uOffset + offset);
                            ++offset;
                        }
                    } else {
                        dst.write(src.subset(src_chroma_idx, tile_width), dst_chroma_idx);
                    }
                    src_chroma_idx += 64;
                    dst_chroma_idx += stride;
                }
                row_width -= 64;
            }
            height -= 32;
        }
    }

    private static int getQcomTilePosition(int x, int y, int w, int h) {
        int flim = x + (y & 0xFFFFFFFE) * w;
        if ((y & 1) != 0) {
            flim += (x & 0xFFFFFFFC) + 2;
        } else if ((h & 1) == 0 || y != h - 1) {
            flim += x + 2 & 0xFFFFFFFC;
        }
        return flim;
    }
}

