/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.graphics.Bitmap;
import fm.icelink.DataBuffer;
import fm.icelink.MediaFormat;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ImageUtility {
    public static VideoBuffer bitmapToBuffer(Bitmap bitmap) throws Exception {
        if (!bitmap.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
            throw new RuntimeException("Bitmap config must be ARGB_8888.");
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getRowBytes() * height);
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        buffer.rewind();
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        return new VideoBuffer(width, height, DataBuffer.wrap((byte[])data, (int)0, (int)data.length), VideoFormat.getArgb());
    }

    public static Bitmap bufferToBitmap(VideoBuffer videoBuffer) {
        if (!((VideoFormat)videoBuffer.getFormat()).getName().equals(VideoFormat.getArgbName())) {
            throw new RuntimeException("Video buffer format must be ARGB.");
        }
        int width = videoBuffer.getWidth();
        int height = videoBuffer.getHeight();
        DataBuffer plane = videoBuffer.getDataBuffer();
        int stride = videoBuffer.getStride();
        byte[] data = plane.getData();
        int index = plane.getIndex();
        int length = plane.getLength();
        if (stride == 0) {
            stride = width * 3;
        }
        if (((VideoFormat)videoBuffer.getFormat()).isEquivalent((MediaFormat)VideoFormat.getArgb())) {
            ByteBuffer buffer = ByteBuffer.allocate(4 * width * height);
            buffer.put(data, index, length);
            buffer.rewind();
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)buffer);
            return bitmap;
        }
        return null;
    }
}

