/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;

public class PGPV3SignatureGenerator {
    private byte lastb;
    private OutputStream sigOut;
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;
    private int sigType;
    private int providedKeyAlgorithm = -1;

    public PGPV3SignatureGenerator(PGPContentSignerBuilder contentSignerBuilder) {
        this.contentSignerBuilder = contentSignerBuilder;
    }

    public void init(int signatureType, PGPPrivateKey key) throws PGPException {
        this.contentSigner = this.contentSignerBuilder.build(signatureType, key);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
    }

    public void update(byte b) {
        if (this.sigType == 1) {
            if (b == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(b);
            }
            this.lastb = b;
        } else {
            this.byteUpdate(b);
        }
    }

    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int off, int len) {
        if (this.sigType == 1) {
            int finish = off + len;
            int i = off;
            while (i != finish) {
                this.update(b[i]);
                ++i;
            }
        } else {
            this.blockUpdate(b, off, len);
        }
    }

    private void byteUpdate(byte b) {
        try {
            this.sigOut.write(b);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException("unable to update signature: " + e.getMessage(), e);
        }
    }

    private void blockUpdate(byte[] block, int off, int len) {
        try {
            this.sigOut.write(block, off, len);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException("unable to update signature: " + e.getMessage(), e);
        }
    }

    public PGPOnePassSignature generateOnePassVersion(boolean isNested) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), isNested));
    }

    public PGPSignature generate() throws PGPException {
        long creationTime = new Date().getTime() / 1000L;
        ByteArrayOutputStream sOut = new ByteArrayOutputStream();
        sOut.write(this.sigType);
        sOut.write((byte)(creationTime >> 24));
        sOut.write((byte)(creationTime >> 16));
        sOut.write((byte)(creationTime >> 8));
        sOut.write((byte)creationTime);
        byte[] hData = sOut.toByteArray();
        this.blockUpdate(hData, 0, hData.length);
        MPInteger[] sigValues = this.contentSigner.getKeyAlgorithm() == 3 || this.contentSigner.getKeyAlgorithm() == 1 ? new MPInteger[]{new MPInteger(new BigInteger(1, this.contentSigner.getSignature()))} : PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
        byte[] digest = this.contentSigner.getDigest();
        byte[] fingerPrint = new byte[]{digest[0], digest[1]};
        return new PGPSignature(new SignaturePacket(3, this.contentSigner.getType(), this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), creationTime * 1000L, fingerPrint, sigValues));
    }
}

