/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.bcpg.attr.ImageAttribute;

public class PGPUserAttributeSubpacketVector {
    UserAttributeSubpacket[] packets;

    PGPUserAttributeSubpacketVector(UserAttributeSubpacket[] packets) {
        this.packets = packets;
    }

    public UserAttributeSubpacket getSubpacket(int type) {
        int i = 0;
        while (i != this.packets.length) {
            if (this.packets[i].getType() == type) {
                return this.packets[i];
            }
            ++i;
        }
        return null;
    }

    public ImageAttribute getImageAttribute() {
        UserAttributeSubpacket p = this.getSubpacket(1);
        if (p == null) {
            return null;
        }
        return (ImageAttribute)p;
    }

    UserAttributeSubpacket[] toSubpacketArray() {
        return this.packets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PGPUserAttributeSubpacketVector) {
            PGPUserAttributeSubpacketVector other = (PGPUserAttributeSubpacketVector)o;
            if (other.packets.length != this.packets.length) {
                return false;
            }
            int i = 0;
            while (i != this.packets.length) {
                if (!other.packets[i].equals(this.packets[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        int i = 0;
        while (i != this.packets.length) {
            code ^= this.packets[i].hashCode();
            ++i;
        }
        return code;
    }
}

