/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

import java.math.BigInteger;
import org.bouncycastle.util.Pack;

public abstract class Nat320 {
    public static void copy64(long[] x, long[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
        z[4] = x[4];
    }

    public static long[] create64() {
        return new long[5];
    }

    public static long[] createExt64() {
        return new long[10];
    }

    public static boolean eq64(long[] x, long[] y) {
        int i = 4;
        while (i >= 0) {
            if (x[i] != y[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static long[] fromBigInteger64(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 320) {
            throw new IllegalArgumentException();
        }
        long[] z = Nat320.create64();
        int i = 0;
        while (x.signum() != 0) {
            z[i++] = x.longValue();
            x = x.shiftRight(64);
        }
        return z;
    }

    public static boolean isOne64(long[] x) {
        if (x[0] != 1L) {
            return false;
        }
        int i = 1;
        while (i < 5) {
            if (x[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isZero64(long[] x) {
        int i = 0;
        while (i < 5) {
            if (x[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static BigInteger toBigInteger64(long[] x) {
        byte[] bs = new byte[40];
        int i = 0;
        while (i < 5) {
            long x_i = x[i];
            if (x_i != 0L) {
                Pack.longToBigEndian(x_i, bs, 4 - i << 3);
            }
            ++i;
        }
        return new BigInteger(1, bs);
    }
}

