/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private int pLen = -1;
    private byte[] fallback = null;

    public PKCS1Encoding(AsymmetricBlockCipher cipher) {
        this.engine = cipher;
        this.useStrictLength = this.useStrict();
    }

    public PKCS1Encoding(AsymmetricBlockCipher cipher, int pLen) {
        this.engine = cipher;
        this.useStrictLength = this.useStrict();
        this.pLen = pLen;
    }

    public PKCS1Encoding(AsymmetricBlockCipher cipher, byte[] fallback) {
        this.engine = cipher;
        this.useStrictLength = this.useStrict();
        this.fallback = fallback;
        this.pLen = fallback.length;
    }

    private boolean useStrict() {
        String strict = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(PKCS1Encoding.STRICT_LENGTH_ENABLED_PROPERTY);
            }
        });
        String notStrict = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(PKCS1Encoding.NOT_STRICT_LENGTH_ENABLED_PROPERTY);
            }
        });
        if (notStrict != null) {
            return !notStrict.equals("true");
        }
        return strict == null || strict.equals("true");
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            kParam = (AsymmetricKeyParameter)param;
            if (!kParam.isPrivate() && forEncryption) {
                this.random = new SecureRandom();
            }
        }
        this.engine.init(forEncryption, param);
        this.forPrivateKey = kParam.isPrivate();
        this.forEncryption = forEncryption;
    }

    @Override
    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - 10;
        }
        return baseBlockSize;
    }

    @Override
    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 10;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    /*
     * Unable to fully structure code
     */
    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        block5: {
            block4: {
                if (inLen > this.getInputBlockSize()) {
                    throw new IllegalArgumentException("input data too large");
                }
                block = new byte[this.engine.getInputBlockSize()];
                if (!this.forPrivateKey) break block4;
                block[0] = 1;
                i = 1;
                while (i != block.length - inLen - 1) {
                    block[i] = -1;
                    ++i;
                }
                break block5;
            }
            this.random.nextBytes(block);
            block[0] = 2;
            i = 1;
            ** GOTO lbl21
            {
                block[i] = (byte)this.random.nextInt();
                do {
                    if (block[i] == 0) continue block1;
                    ++i;
lbl21:
                    // 2 sources

                } while (i != block.length - inLen - 1);
            }
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        return this.engine.processBlock(block, 0, block.length);
    }

    private static int checkPkcs1Encoding(byte[] encoded, int pLen) {
        int correct = 0;
        correct |= encoded[0] ^ 2;
        int plen = encoded.length - (pLen + 1);
        int i = 1;
        while (i < plen) {
            int tmp = encoded[i];
            tmp |= tmp >> 1;
            tmp |= tmp >> 2;
            tmp |= tmp >> 4;
            correct |= (tmp & 1) - 1;
            ++i;
        }
        correct |= encoded[encoded.length - (pLen + 1)];
        correct |= correct >> 1;
        correct |= correct >> 2;
        correct |= correct >> 4;
        return ~((correct & 1) - 1);
    }

    private byte[] decodeBlockOrRandom(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (!this.forPrivateKey) {
            throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
        }
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        byte[] random = null;
        if (this.fallback == null) {
            random = new byte[this.pLen];
            this.random.nextBytes(random);
        } else {
            random = this.fallback;
        }
        if (block.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        if (this.useStrictLength && block.length != this.engine.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block incorrect size");
        }
        int correct = PKCS1Encoding.checkPkcs1Encoding(block, this.pLen);
        byte[] result = new byte[this.pLen];
        int i = 0;
        while (i < this.pLen) {
            result[i] = (byte)(block[i + (block.length - this.pLen)] & ~correct | random[i] & correct);
            ++i;
        }
        return result;
    }

    private byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.pLen != -1) {
            return this.decodeBlockOrRandom(in, inOff, inLen);
        }
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        if (block.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        byte type = block[0];
        if (this.forPrivateKey ? type != 2 : type != 1) {
            throw new InvalidCipherTextException("unknown block type");
        }
        if (this.useStrictLength && block.length != this.engine.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block incorrect size");
        }
        int start = 1;
        while (start != block.length) {
            byte pad = block[start];
            if (pad == 0) break;
            if (type == 1 && pad != -1) {
                throw new InvalidCipherTextException("block padding incorrect");
            }
            ++start;
        }
        if (++start > block.length || start < 10) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] result = new byte[block.length - start];
        System.arraycopy(block, start, result, 0, result.length);
        return result;
    }
}

