/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.bcpg.UserAttributeSubpacketInputStream;

public class UserAttributePacket
extends ContainedPacket {
    private UserAttributeSubpacket[] subpackets;

    public UserAttributePacket(BCPGInputStream in) throws IOException {
        UserAttributeSubpacket sub;
        UserAttributeSubpacketInputStream sIn = new UserAttributeSubpacketInputStream(in);
        Vector<UserAttributeSubpacket> v = new Vector<UserAttributeSubpacket>();
        while ((sub = sIn.readPacket()) != null) {
            v.addElement(sub);
        }
        this.subpackets = new UserAttributeSubpacket[v.size()];
        int i = 0;
        while (i != this.subpackets.length) {
            this.subpackets[i] = (UserAttributeSubpacket)v.elementAt(i);
            ++i;
        }
    }

    public UserAttributePacket(UserAttributeSubpacket[] subpackets) {
        this.subpackets = subpackets;
    }

    public UserAttributeSubpacket[] getSubpackets() {
        return this.subpackets;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int i = 0;
        while (i != this.subpackets.length) {
            this.subpackets[i].encode(bOut);
            ++i;
        }
        out.writePacket(17, bOut.toByteArray(), false);
    }
}

