/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vp8;

import fm.icelink.DataBuffer;
import fm.icelink.IVideoSource;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.LongHolder;
import fm.icelink.RtpPacket;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoDepacketizer;
import fm.icelink.vp8.Accumulator;
import fm.icelink.vp8.Format;
import fm.icelink.vp8.Utility;

public class Depacketizer
extends VideoDepacketizer {
    private Accumulator __accumulator = new Accumulator();

    @Override
    protected DataBuffer depacketize(VideoBuffer inputBuffer, LongHolder newSequenceNumber) {
        int num;
        DataBuffer _var0 = this.__accumulator.add(RtpPacket.wrap(inputBuffer.getDataBuffer()), inputBuffer.getSequenceNumber(), newSequenceNumber);
        DataBuffer buffer = _var0;
        if (buffer != null && (num = this.__accumulator.clearAged()) > 0) {
            Log.debug(StringExtensions.format("{0} VP8 packet(s) could not be reassembled and were discarded.", IntegerExtensions.toString(num)));
        }
        return buffer;
    }

    public Depacketizer(IVideoSource source) {
        this();
        super.addSource(source);
    }

    public Depacketizer() {
        super(new Format());
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public String getLabel() {
        return "VP8 Depacketizer";
    }

    @Override
    protected boolean isKeyFrame(DataBuffer inputBuffer) {
        return Utility.isKeyFrame(inputBuffer);
    }
}

