/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vp8;

import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.LongHolder;
import fm.icelink.MathAssistant;
import fm.icelink.vp8.Fragment;
import java.util.ArrayList;

class Assembler {
    private static int __maxAge = 2;
    private int _age = 0;
    private ArrayList<Fragment> _fragments = new ArrayList();

    public void add(Fragment fragment) {
        for (int i = 0; i < ArrayListExtensions.getCount(this._fragments); ++i) {
            Fragment fragment2 = ArrayListExtensions.getItem(this._fragments).get(i);
            if (fragment.getSequenceNumber() >= fragment2.getSequenceNumber()) continue;
            ArrayListExtensions.insert(this._fragments, i, fragment);
            return;
        }
        this._fragments.add(fragment);
    }

    public DataBuffer assemble(LongHolder sequenceNumber) {
        int count = 0;
        sequenceNumber.setValue(0L);
        for (Fragment fragment : this._fragments) {
            sequenceNumber.setValue(MathAssistant.max(sequenceNumber.getValue(), fragment.getSequenceNumber()));
            count += fragment.getBuffer().getLength();
        }
        int offset = 0;
        DataBuffer buffer = DataBuffer.allocate(count);
        for (Fragment fragment : this._fragments) {
            DataBuffer buffer2 = fragment.getBuffer();
            int length = buffer2.getLength();
            buffer.write(buffer2, offset);
            offset += length;
        }
        return buffer;
    }

    public Assembler(Fragment fragment) {
        this.add(fragment);
    }

    public boolean getIsAged() {
        return this._age >= Assembler.getMaxAge();
    }

    public boolean getIsComplete() {
        if (!ArrayListExtensions.getItem(this._fragments).get(0).getFirst()) {
            return false;
        }
        if (!ArrayListExtensions.getItem(this._fragments).get(ArrayListExtensions.getCount(this._fragments) - 1).getLast()) {
            return false;
        }
        long sequenceNumber = -1L;
        for (Fragment fragment : this._fragments) {
            if (sequenceNumber == -1L) {
                sequenceNumber = fragment.getSequenceNumber();
                continue;
            }
            if (++sequenceNumber == fragment.getSequenceNumber()) continue;
            return false;
        }
        return true;
    }

    public static int getMaxAge() {
        return __maxAge;
    }

    public void increaseAge() {
        ++this._age;
    }

    public static void setMaxAge(int value) {
        __maxAge = value;
    }
}

