/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun.turn;

import fm.icelink.Binary;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.stun.Attribute;

public class ChannelNumberAttribute
extends Attribute {
    private int _channelNumber;

    private ChannelNumberAttribute() {
    }

    public ChannelNumberAttribute(int channelNumber) {
        this.setChannelNumber(channelNumber);
    }

    public static ChannelNumberAttribute fromValueBytes(byte[] valueBytes) {
        ChannelNumberAttribute attribute = new ChannelNumberAttribute();
        attribute.setChannelNumber(Binary.fromBytes16(valueBytes, 0, false));
        return attribute;
    }

    public int getChannelNumber() {
        return this._channelNumber;
    }

    @Override
    protected byte[] getValueBytes() {
        byte[] buffer = new byte[4];
        Binary.toBytes16(this.getChannelNumber(), false);
        return buffer;
    }

    public void setChannelNumber(int value) {
        this._channelNumber = value;
    }

    public String toString() {
        return StringExtensions.format("CHANNEL-NUMBER {0}", IntegerExtensions.toString(this.getChannelNumber()));
    }
}

