/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.stun.Attribute;
import java.util.ArrayList;

public class UnknownAttributesAttribute
extends Attribute {
    private ArrayList<byte[]> _typeList = new ArrayList();

    public void addType(byte[] type) {
        this._typeList.add(type);
    }

    public static UnknownAttributesAttribute fromValueBytes(byte[] valueBytes) {
        UnknownAttributesAttribute attribute = new UnknownAttributesAttribute();
        for (int i = 0; i < ArrayExtensions.getLength(valueBytes); i += 2) {
            byte[] item = BitAssistant.subArray(valueBytes, i, 2);
            if (item[0] == 0 && item[1] == 0) continue;
            attribute._typeList.add(item);
        }
        return attribute;
    }

    public ArrayList<byte[]> getTypes() {
        return this._typeList;
    }

    @Override
    protected byte[] getValueBytes() {
        ByteCollection bytes = new ByteCollection();
        if (this.getTypes() != null) {
            for (byte[] buffer : this.getTypes()) {
                bytes.addRange(buffer);
            }
        }
        return bytes.toArray();
    }

    public void removeType(byte[] type) {
        this._typeList.remove(type);
    }
}

