/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ArrayListExtensions;
import fm.icelink.ErrorCode;
import fm.icelink.StringExtensions;
import fm.icelink.stun.Error;
import fm.icelink.stun.UnknownAttributesAttribute;

public class UnknownAttributeError
extends Error {
    private UnknownAttributesAttribute _unknownAttributes;

    @Override
    public String getDescription() {
        String str = super.getErrorCode().toString();
        if (super.getMessage() == null) {
            super.setMessage("Server responded with 420 Unknown Attribute.");
        }
        str = StringExtensions.concat(str, " ", super.getMessage().trim());
        if (this.getUnknownAttributes() != null) {
            str = StringExtensions.concat(str, " . Unknow types:");
            if (ArrayListExtensions.getCount(this.getUnknownAttributes().getTypes()) == 0) {
                str = StringExtensions.concat(str, " None.");
            }
            for (byte[] buffer : this.getUnknownAttributes().getTypes()) {
                str = StringExtensions.concat(str, " ", buffer.toString());
            }
        }
        return str;
    }

    public UnknownAttributesAttribute getUnknownAttributes() {
        return this._unknownAttributes;
    }

    private void setUnknownAttributes(UnknownAttributesAttribute value) {
        this._unknownAttributes = value;
    }

    public UnknownAttributeError(String message, UnknownAttributesAttribute unknownAttributes) {
        super(ErrorCode.StunUnknownAttribute, message);
        this.setUnknownAttributes(unknownAttributes);
    }

    public UnknownAttributeError(UnknownAttributesAttribute unknownAttributes) {
        this(null, unknownAttributes);
    }
}

