/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ArrayExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import fm.icelink.stun.Attribute;

public class RealmAttribute
extends Attribute {
    private String __value;

    public static RealmAttribute fromValueBytes(byte[] valueBytes) {
        String str = Utf8.decode(valueBytes, 0, ArrayExtensions.getLength(valueBytes)).trim();
        while (str.endsWith("\u0000")) {
            str = StringExtensions.substring(str, 0, StringExtensions.getLength(str) - 1);
        }
        RealmAttribute attribute = new RealmAttribute();
        attribute.setValue(str);
        return attribute;
    }

    public String getValue() {
        return this.__value;
    }

    @Override
    protected byte[] getValueBytes() {
        return Utf8.encode(this.getValue());
    }

    public RealmAttribute(String value) {
        this.setValue(value);
    }

    private RealmAttribute() {
    }

    public void setValue(String value) {
        if (StringExtensions.getLength(value) > 127) {
            throw new RuntimeException(new Exception("value must have fewer than 128 characters."));
        }
        this.__value = value;
    }

    public String toString() {
        return StringExtensions.format("REALM {0}", this.getValue());
    }
}

