/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.BitAssistant;
import fm.icelink.Crypto;
import fm.icelink.DataBuffer;
import fm.icelink.stun.Attribute;

public class MessageIntegrityAttribute
extends Attribute {
    private byte[] _keyBytes;
    private byte[] _messageBytes;
    private byte[] _valueBytes;

    public static MessageIntegrityAttribute fromValueBytes(byte[] valueBytes, byte[] messageBytes) {
        MessageIntegrityAttribute attribute = new MessageIntegrityAttribute();
        attribute._valueBytes = valueBytes;
        attribute._messageBytes = messageBytes;
        return attribute;
    }

    byte[] getBytes(byte[] messageBytes) {
        if (messageBytes == null) {
            throw new RuntimeException(new Exception("messageBytes cannot be null."));
        }
        this._messageBytes = messageBytes;
        byte[] bytes = super.getBytes();
        this._messageBytes = null;
        return bytes;
    }

    @Override
    protected byte[] getValueBytes() {
        return Crypto.getHmacSha1(this._keyBytes, DataBuffer.wrap(this._messageBytes));
    }

    public boolean isValid(byte[] keyBytes) {
        return this._valueBytes != null && BitAssistant.sequencesAreEqual(this._valueBytes, Crypto.getHmacSha1(keyBytes, DataBuffer.wrap(this._messageBytes)));
    }

    public MessageIntegrityAttribute(byte[] keyBytes) {
        this._keyBytes = keyBytes;
    }

    private MessageIntegrityAttribute() {
    }

    public String toString() {
        return "MESSAGE-INTEGRITY";
    }
}

