/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ErrorCode;
import fm.icelink.IntegerExtensions;
import fm.icelink.stun.AlternateServerAttribute;
import fm.icelink.stun.BadRequestError;
import fm.icelink.stun.Message;
import fm.icelink.stun.MissingUsernameError;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;
import fm.icelink.stun.ServerError;
import fm.icelink.stun.StaleCredentialsError;
import fm.icelink.stun.StaleNonceError;
import fm.icelink.stun.TryAlternateStunError;
import fm.icelink.stun.UnauthorizedStunError;
import fm.icelink.stun.UnknownAttributeError;
import fm.icelink.stun.UnknownAttributesAttribute;
import fm.icelink.stun.ice.ControlledAttribute;
import fm.icelink.stun.ice.RoleConflictError;
import fm.icelink.stun.turn.AddressFamilyNotSupportedError;
import fm.icelink.stun.turn.AllocationMismatchError;
import fm.icelink.stun.turn.AllocationQuotaReachedError;
import fm.icelink.stun.turn.ConnectionAlreadyExistsError;
import fm.icelink.stun.turn.ConnectionTimeoutOrFailureError;
import fm.icelink.stun.turn.ForbiddenError;
import fm.icelink.stun.turn.InsufficientCapacityError;
import fm.icelink.stun.turn.MobilityForbiddenError;
import fm.icelink.stun.turn.PeerAddressFamilyMismatchError;
import fm.icelink.stun.turn.UnsupportedTransportProtocolError;
import fm.icelink.stun.turn.WrongCredentialsError;

public abstract class Error
extends fm.icelink.Error {
    private String _message;

    private static Error createAddressFamilyNotSupportedError(Message e) {
        return new AddressFamilyNotSupportedError();
    }

    private static Error createAllocationMismatchError(Message e) {
        return new AllocationMismatchError("Server responded with 437 Allocation Mismatch.");
    }

    private static Error createAllocationQuotaReachedError(Message e) {
        return new AllocationQuotaReachedError("Server responded with 486 Allocation Quota Reached.");
    }

    private static Error createBadRequestError(Message e) {
        return new BadRequestError("Server responded with 400 Bad Request.");
    }

    private static Error createConnectionAlreadyExistsError(Message e) {
        return new ConnectionAlreadyExistsError("Server responded with 446 Connection Already Exists.");
    }

    private static Error createConnectionTimeoutOrFailureError(Message e) {
        return new ConnectionTimeoutOrFailureError("Server responded with 447 Connection Timeout or Failure.");
    }

    private static Error createForbiddenError(Message e) {
        return new ForbiddenError("Server responded with 403 Forbidden.");
    }

    private static Error createInsufficientCapacityError(Message e) {
        return new InsufficientCapacityError("Server responded with 508 Insufficient Capacity.");
    }

    private static fm.icelink.Error createIntegrityCheckFailureError(Message e) {
        return new MissingUsernameError("Server responded with 431 Integrity Check Failure.");
    }

    private static fm.icelink.Error createMissingUsernameError(Message e) {
        return new MissingUsernameError("Server responded with 432 Missing Username.");
    }

    private static Error createMobilityForbiddenError(Message e) {
        return new MobilityForbiddenError("Server responded with 405 Mobility Forbidden.");
    }

    private static Error createPeerAddressFamilyMismatchError(Message e) {
        return new PeerAddressFamilyMismatchError("Server responded with 443 Peer Address Family Mismatch.");
    }

    private static Error createRoleConflictError(Message e) {
        ControlledAttribute iceControlled = e.getIceControlled();
        return new RoleConflictError("Server responded with 487 Role Conflict.", iceControlled, e.getIceControlling());
    }

    private static Error createServerError(Message e) {
        return new ServerError("Server responded with 500 Server Error.");
    }

    private static fm.icelink.Error createStaleCredentialsError(Message e) {
        return new StaleCredentialsError("Server responded with 430 Stale Credentials.");
    }

    private static fm.icelink.Error createStaleNonceError(Message e) {
        NonceAttribute nonce = e.getNonce();
        RealmAttribute realm = e.getRealm();
        if (nonce == null) {
            return new fm.icelink.Error(ErrorCode.StunInvalidErrorCode, new Exception("Server responded with 438 Stale Nonce, but NONCE is missing."));
        }
        return new StaleNonceError("Server responded with 438 Stale Nonce.", nonce, realm);
    }

    public static fm.icelink.Error createStunError(int errorCode, Message message) {
        String _var0 = IntegerExtensions.toString(errorCode);
        if (_var0.equals("300")) {
            return Error.createTryAlternateError(message);
        }
        if (_var0.equals("400")) {
            return Error.createBadRequestError(message);
        }
        if (_var0.equals("401")) {
            return Error.createUnauthorizedError(message);
        }
        if (_var0.equals("403")) {
            return Error.createForbiddenError(message);
        }
        if (_var0.equals("405")) {
            return Error.createMobilityForbiddenError(message);
        }
        if (_var0.equals("420")) {
            return Error.createUnknownAttributeError(message);
        }
        if (_var0.equals("430")) {
            return Error.createStaleCredentialsError(message);
        }
        if (_var0.equals("431")) {
            return Error.createIntegrityCheckFailureError(message);
        }
        if (_var0.equals("432")) {
            return Error.createMissingUsernameError(message);
        }
        if (_var0.equals("437")) {
            return Error.createAllocationMismatchError(message);
        }
        if (_var0.equals("438")) {
            return Error.createStaleNonceError(message);
        }
        if (_var0.equals("440")) {
            return Error.createAddressFamilyNotSupportedError(message);
        }
        if (_var0.equals("441")) {
            return Error.createWrongCredentialsError(message);
        }
        if (_var0.equals("442")) {
            return Error.createUnsupportedTransportProtocolError(message);
        }
        if (_var0.equals("443")) {
            return Error.createPeerAddressFamilyMismatchError(message);
        }
        if (_var0.equals("446")) {
            return Error.createConnectionAlreadyExistsError(message);
        }
        if (_var0.equals("447")) {
            return Error.createConnectionTimeoutOrFailureError(message);
        }
        if (_var0.equals("486")) {
            return Error.createAllocationQuotaReachedError(message);
        }
        if (_var0.equals("487")) {
            return Error.createRoleConflictError(message);
        }
        if (_var0.equals("500")) {
            return Error.createServerError(message);
        }
        if (_var0.equals("508")) {
            return Error.createInsufficientCapacityError(message);
        }
        return null;
    }

    private static fm.icelink.Error createTryAlternateError(Message e) {
        if (e.getMessageIntegrity() == null) {
            return new fm.icelink.Error(ErrorCode.StunInvalidMessageIntegrity, new Exception("Server responded with 300 Try Alternate, but MESSAGE-INTEGRITY check failed."));
        }
        AlternateServerAttribute alternateServer = e.getAlternateServer();
        if (alternateServer == null) {
            return new fm.icelink.Error(ErrorCode.StunInvalidErrorCode, new Exception("Server responded with 300 Try Alternate, but ALTERNATE-SERVER is missing."));
        }
        return new TryAlternateStunError("Server responded with 300 Try Alternate.", alternateServer);
    }

    private static Error createUnauthorizedError(Message e) {
        NonceAttribute nonce = e.getNonce();
        return new UnauthorizedStunError(nonce, e.getRealm(), "Server responded with 401 Unauthorized.");
    }

    private static fm.icelink.Error createUnknownAttributeError(Message e) {
        UnknownAttributesAttribute unknownAttributes = e.getUnknownAttributes();
        if (unknownAttributes == null) {
            return new fm.icelink.Error(ErrorCode.StunInvalidErrorCode, new Exception("Server responded with 420 Unknown Attribute, but UNKNOWN-ATTRIBUTES is missing."));
        }
        return new UnknownAttributeError("Server responded with 420 Unknown Attribute.", unknownAttributes);
    }

    private static Error createUnsupportedTransportProtocolError(Message e) {
        return new UnsupportedTransportProtocolError("Server responded with 442 Unsupported Transport Protocol.");
    }

    private static Error createWrongCredentialsError(Message e) {
        return new WrongCredentialsError("Server responded with 441 Wrong Credentials.");
    }

    public Error(ErrorCode icelinkErrorCode, String message) {
        super(icelinkErrorCode);
        this.setMessage(message);
    }

    public String getMessage() {
        return this._message;
    }

    public int getStunErrorCode() {
        ErrorCode _var0 = super.getErrorCode();
        if (_var0 == ErrorCode.StunTryAlternate) {
            return 300;
        }
        if (_var0 == ErrorCode.StunBadRequest) {
            return 400;
        }
        if (_var0 == ErrorCode.StunUnauthorized) {
            return 401;
        }
        if (_var0 == ErrorCode.StunTurnForbidden) {
            return 403;
        }
        if (_var0 == ErrorCode.StunTurnMobilityForbidden) {
            return 405;
        }
        if (_var0 == ErrorCode.StunUnknownAttribute) {
            return 420;
        }
        if (_var0 == ErrorCode.StunStaleCredentials) {
            return 430;
        }
        if (_var0 == ErrorCode.StunIntegrityCheckFailure) {
            return 431;
        }
        if (_var0 == ErrorCode.StunMissingUsername) {
            return 432;
        }
        if (_var0 == ErrorCode.StunTurnAllocationMismatch) {
            return 437;
        }
        if (_var0 == ErrorCode.StunStaleNonce) {
            return 438;
        }
        if (_var0 == ErrorCode.StunAddressFamilyNotSupported) {
            return 440;
        }
        if (_var0 == ErrorCode.StunTurnWrongCredentials) {
            return 441;
        }
        if (_var0 == ErrorCode.StunTurnUnsupportedTransportProtocol) {
            return 442;
        }
        if (_var0 == ErrorCode.StunTurnPeerAddressFamilyMismatch) {
            return 443;
        }
        if (_var0 == ErrorCode.StunTurnConnectionAlreadyExists) {
            return 446;
        }
        if (_var0 == ErrorCode.StunTurnConnectionTimeoutOrFailure) {
            return 447;
        }
        if (_var0 == ErrorCode.StunTurnAllocationQuotaReached) {
            return 486;
        }
        if (_var0 == ErrorCode.StunIceRoleConflict) {
            return 487;
        }
        if (_var0 == ErrorCode.StunServerError) {
            return 500;
        }
        if (_var0 == ErrorCode.StunTurnInsufficientCapacity) {
            return 508;
        }
        return -1;
    }

    public void setMessage(String value) {
        this._message = value;
    }
}

