/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.rtcp;

import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.ParseAssistant;
import fm.icelink.StringComparison;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.rtcp.FeedbackAttributeSubType;
import fm.icelink.sdp.rtcp.FeedbackAttributeType;

public class FeedbackAttribute
extends Attribute {
    private int _payloadType;
    private String _subType;
    private String _type;

    public static FeedbackAttribute ccmFirAttribute(int payloadType) {
        return new FeedbackAttribute(payloadType, FeedbackAttributeType.getCcm(), FeedbackAttributeSubType.getFir());
    }

    private FeedbackAttribute() {
        super.setAttributeType(AttributeType.RtcpFeedbackAttribute);
    }

    public FeedbackAttribute(int payloadType, String type) {
        this(payloadType, type, null);
    }

    public FeedbackAttribute(int payloadType, String type, String subtype) {
        super.setAttributeType(AttributeType.RtcpFeedbackAttribute);
        this.setPayloadType(payloadType);
        this.setType(type);
        this.setSubType(subtype);
    }

    public static FeedbackAttribute fromAttributeValue(String value) {
        int wildcardPayloadType = FeedbackAttribute.getWildcardPayloadType();
        int index = StringExtensions.indexOf(value, " ", StringComparison.InvariantCulture);
        if (index < 0) {
            Log.error(StringExtensions.concat("Could not parse SDP attribute (RTCP feedback): ", value));
            return null;
        }
        String s = StringExtensions.substring(value, 0, index);
        if (!Global.equals(s, "*")) {
            wildcardPayloadType = ParseAssistant.parseIntegerValue(s);
        }
        String str2 = value = value.substring(index + 1);
        String str3 = null;
        index = StringExtensions.indexOf(value, " ", StringComparison.InvariantCulture);
        if (index >= 0) {
            str2 = StringExtensions.substring(value, 0, index);
            str3 = value = value.substring(index + 1);
        }
        FeedbackAttribute attribute = new FeedbackAttribute();
        attribute.setPayloadType(wildcardPayloadType);
        attribute.setType(str2);
        attribute.setSubType(str3);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        String str;
        String string = str = this.getPayloadType() == FeedbackAttribute.getWildcardPayloadType() ? "*" : IntegerExtensions.toString(this.getPayloadType());
        if (this.getSubType() == null) {
            return StringExtensions.format("{0} {1}", str, this.getType());
        }
        return StringExtensions.format("{0} {1} {2}", str, this.getType(), this.getSubType());
    }

    public int getPayloadType() {
        return this._payloadType;
    }

    public String getSubType() {
        return this._subType;
    }

    public String getType() {
        return this._type;
    }

    public static int getWildcardPayloadType() {
        return -1;
    }

    public static FeedbackAttribute nackAttribute(int payloadType) {
        return new FeedbackAttribute(payloadType, FeedbackAttributeType.getNack());
    }

    public static FeedbackAttribute nackPliAttribute(int payloadType) {
        return new FeedbackAttribute(payloadType, FeedbackAttributeType.getNack(), FeedbackAttributeSubType.getPli());
    }

    public static FeedbackAttribute nackRpsiAttribute(int payloadType) {
        return new FeedbackAttribute(payloadType, FeedbackAttributeType.getNack(), FeedbackAttributeSubType.getRpsi());
    }

    public static FeedbackAttribute nackSliAttribute(int payloadType) {
        return new FeedbackAttribute(payloadType, FeedbackAttributeType.getNack(), FeedbackAttributeSubType.getSli());
    }

    public void setPayloadType(int value) {
        this._payloadType = value;
    }

    public void setSubType(String value) {
        this._subType = value;
    }

    public void setType(String value) {
        this._type = value;
    }
}

