/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.ice;

import fm.icelink.ArrayExtensions;
import fm.icelink.StringAssistant;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.ice.RemoteCandidate;
import java.util.ArrayList;

public class RemoteCandidatesAttribute
extends Attribute {
    private RemoteCandidate[] _candidates;

    public static RemoteCandidatesAttribute fromAttributeValue(String value) {
        Object[] array = StringExtensions.split(value, new char[]{' '});
        ArrayList<RemoteCandidate> list = new ArrayList<RemoteCandidate>();
        for (int i = 0; i < ArrayExtensions.getLength(array); i += 3) {
            list.add(RemoteCandidate.parse(StringExtensions.join(" ", StringAssistant.subArray((String[])array, i, 3))));
        }
        RemoteCandidatesAttribute attribute = new RemoteCandidatesAttribute();
        attribute.setCandidates(list.toArray(new RemoteCandidate[0]));
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        String[] strArray = new String[ArrayExtensions.getLength(this.getCandidates())];
        for (int i = 0; i < ArrayExtensions.getLength(this.getCandidates()); ++i) {
            strArray[i] = this.getCandidates()[i].toString();
        }
        return StringExtensions.join(" ", strArray);
    }

    public RemoteCandidate[] getCandidates() {
        return this._candidates;
    }

    private RemoteCandidatesAttribute() {
        super.setAttributeType(AttributeType.IceRemoteCandidatesAttribute);
    }

    public RemoteCandidatesAttribute(RemoteCandidate[] candidates) {
        super.setAttributeType(AttributeType.IceRemoteCandidatesAttribute);
        if (candidates == null) {
            throw new RuntimeException(new Exception("candidates cannot be null."));
        }
        this.setCandidates(candidates);
    }

    private void setCandidates(RemoteCandidate[] value) {
        this._candidates = value;
    }
}

