/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.ice;

import fm.icelink.Guid;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;

public class PasswordAttribute
extends Attribute {
    private String _password;

    public static PasswordAttribute fromAttributeValue(String value) {
        return new PasswordAttribute(value);
    }

    public static String generatePassword() {
        return Guid.newGuid().toString().replace("-", "");
    }

    @Override
    protected String getAttributeValue() {
        return this.getPassword();
    }

    public String getPassword() {
        return this._password;
    }

    public PasswordAttribute(String password) {
        super.setAttributeType(AttributeType.IcePasswordAttribute);
        if (StringExtensions.getLength(password) < 22 || StringExtensions.getLength(password) > 256) {
            throw new RuntimeException(new Exception("password must be at least 22 characters long up to 256 characters."));
        }
        this.setPassword(password);
    }

    public PasswordAttribute() {
        this(PasswordAttribute.generatePassword());
    }

    private void setPassword(String value) {
        this._password = value;
    }
}

