/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ArrayExtensions;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IntegerExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringComparison;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;
import java.util.ArrayList;
import java.util.HashMap;

public class FormatParametersAttribute
extends Attribute {
    private int _format;
    private String _formatSpecificParameters;

    public HashMap<String, String> deserializeFormatSpecificParameters() {
        HashMap<String, String> dictionary = new HashMap<String, String>();
        String formatSpecificParameters = this.getFormatSpecificParameters();
        if (formatSpecificParameters != null) {
            String[] strArray;
            for (String str2 : strArray = StringExtensions.split(formatSpecificParameters, new char[]{';'})) {
                Object[] strArray2 = StringExtensions.split(str2.trim(), new char[]{'='});
                if (ArrayExtensions.getLength(strArray2) == 1) {
                    HashMapExtensions.set(HashMapExtensions.getItem(dictionary), strArray2[0], null);
                    continue;
                }
                HashMapExtensions.set(HashMapExtensions.getItem(dictionary), strArray2[0], strArray2[1]);
            }
        }
        return dictionary;
    }

    private FormatParametersAttribute() {
        super.setAttributeType(AttributeType.FormatParametersAttribute);
    }

    public FormatParametersAttribute(int format) {
        this(format, null);
    }

    public FormatParametersAttribute(int format, String formatSpecificParameters) {
        super.setAttributeType(AttributeType.FormatParametersAttribute);
        this.setFormat(format);
        this.setFormatSpecificParameters(formatSpecificParameters);
    }

    public static FormatParametersAttribute fromAttributeValue(String value) {
        int index = StringExtensions.indexOf(value, " ", StringComparison.InvariantCulture);
        int num2 = ParseAssistant.parseIntegerValue(StringExtensions.substring(value, 0, index));
        String str = value.substring(index + 1);
        FormatParametersAttribute attribute = new FormatParametersAttribute();
        attribute.setFormat(num2);
        attribute.setFormatSpecificParameters(str);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getFormat()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getFormatSpecificParameters());
        return builder.toString();
    }

    public int getFormat() {
        return this._format;
    }

    public String getFormatSpecificParameter(String key) {
        return HashMapExtensions.getItem(this.deserializeFormatSpecificParameters()).get(key);
    }

    public String getFormatSpecificParameters() {
        return this._formatSpecificParameters;
    }

    public void serializeFormatSpecificParameters(HashMap<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : HashMapExtensions.getKeys(map)) {
            if (HashMapExtensions.getItem(map).get(str) == null) {
                list.add(str);
                continue;
            }
            list.add(StringExtensions.join("=", new String[]{str, HashMapExtensions.getItem(map).get(str)}));
        }
        this.setFormatSpecificParameters(StringExtensions.join(";", list.toArray(new String[0])));
    }

    private void setFormat(int value) {
        this._format = value;
    }

    public void setFormatSpecificParameter(String key, String value) {
        HashMap<String, String> map = this.deserializeFormatSpecificParameters();
        HashMapExtensions.set(HashMapExtensions.getItem(map), key, value);
        this.serializeFormatSpecificParameters(map);
    }

    private void setFormatSpecificParameters(String value) {
        this._formatSpecificParameters = value;
    }

    public boolean tryGetFormatSpecificParameter(String key, Holder<String> value) {
        HashMap<String, String> dictionary = this.deserializeFormatSpecificParameters();
        value.setValue(null);
        boolean _var0 = HashMapExtensions.tryGetValue(dictionary, key, value);
        return _var0;
    }

    public boolean unsetFormatSpecificParameter(String key) {
        HashMap<String, String> map = this.deserializeFormatSpecificParameters();
        if (HashMapExtensions.remove(map, key)) {
            this.serializeFormatSpecificParameters(map);
            return true;
        }
        return false;
    }
}

