/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum AttributeType {
    UnknownAttribute(999666),
    DirectionAttribute(1),
    CategoryAttribute(2),
    CharacterSetAttribute(3),
    ConferenceTypeAttribute(4),
    CryptoAttribute(5),
    FormatParametersAttribute(6),
    FrameRateAttribute(7),
    KeywordsAttribute(8),
    LanguageAttribute(9),
    MaxPacketTimeAttribute(10),
    OrientationAttribute(11),
    PacketTimeAttribute(12),
    QualityAttribute(13),
    SdpLanguageAttribute(14),
    SetupAttribute(15),
    ToolAttribute(16),
    MediaStreamIdSemanticAttribute(17),
    MediaStreamIdAttribute(18),
    IceCandidateAttribute(19),
    IceFingerprintAttribute(20),
    IceLiteAttribute(21),
    IceMismatchAttribute(22),
    IceOptionsAttribute(23),
    IcePasswordAttribute(24),
    IceUfragAttribute(25),
    IceRemoteCandidatesAttribute(26),
    RtpMapAttribute(27),
    RtpSsrcAttribute(28),
    RtcpAttribute(29),
    RtcpFeedbackAttribute(30),
    RtcpMuxAttribute(31),
    SctpPortAttribute(32),
    SctpMapAttribute(33),
    SctpMaxMessageSizeAttribute(34);

    private final int value;
    private static final Map<Integer, AttributeType> lookup;

    private AttributeType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static AttributeType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, AttributeType>();
        for (AttributeType s : EnumSet.allOf(AttributeType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

