/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.ogg;

import fm.icelink.ArrayExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferStream;
import fm.icelink.Encoding;
import fm.icelink.Global;
import fm.icelink.StringExtensions;
import fm.icelink.ogg.Page;

public class AudioRecorder
extends fm.icelink.AudioRecorder {
    private String __artist = "Frozen Mountain";
    private AudioFormat __inputFormat;
    private boolean __isOpus;
    private boolean __isPcm;
    private boolean __isPcma;
    private boolean __isPcmu;
    private String __title = "IceLink WebRTC Audio Stream";
    private String __vendor = "Frozen Mountain";
    private int _absoluteGranulePosition;
    private double[] _opusFrameSizes = new double[]{10.0, 20.0, 40.0, 60.0, 10.0, 20.0, 40.0, 60.0, 10.0, 20.0, 40.0, 60.0, 10.0, 20.0, 10.0, 20.0, 2.5, 5.0, 10.0, 20.0, 2.5, 5.0, 10.0, 20.0, 2.5, 5.0, 10.0, 20.0, 2.5, 5.0, 10.0, 20.0};
    private int _sequenceNumber;
    private int _streamSerialNumber;

    public AudioRecorder(String path, AudioFormat inputFormat) {
        super(path);
        this.__inputFormat = inputFormat;
        if (Global.equals(inputFormat.getName(), AudioFormat.getOpusName())) {
            this.__isOpus = true;
        } else if (Global.equals(inputFormat.getName(), AudioFormat.getPcmuName())) {
            this.__isPcmu = true;
        } else if (Global.equals(inputFormat.getName(), AudioFormat.getPcmaName())) {
            this.__isPcma = true;
        } else {
            if (!Global.equals(inputFormat.getName(), AudioFormat.getPcmName())) {
                throw new RuntimeException(new Exception(StringExtensions.format("Ogg audio recorder does not support the '{0}' codec.", inputFormat.getName())));
            }
            this.__isPcm = true;
        }
        this._streamSerialNumber = 1;
    }

    @Override
    protected void doUpdateHeader() {
    }

    @Override
    protected boolean doWrite(AudioBuffer audioBuffer, long presentationTimestamp) {
        DataBuffer dataBuffer = audioBuffer.getDataBuffer();
        if (this.__isOpus) {
            int num = dataBuffer.read8(0);
            int index = (num & 0xF8) >> 3;
            int num3 = num & 3;
            double num4 = this._opusFrameSizes[index];
            int num5 = 0;
            if (num3 == 0) {
                num5 = 1;
            } else if (num3 == 1) {
                num5 = 2;
            } else if (num3 == 2) {
                num5 = 2;
            } else if (num3 == 3 && dataBuffer.getLength() > 1) {
                num5 = dataBuffer.read8(1) & 0x3F;
            }
            int num6 = (int)((double)this.__inputFormat.getClockRate() * num4 * (double)num5 / 1000.0);
            int num7 = num6 * 48000 / this.__inputFormat.getClockRate();
            this._absoluteGranulePosition += num7;
        } else if (this.__isPcm) {
            int num6 = dataBuffer.getLength() / (this.__inputFormat.getChannelCount() * 2);
            this._absoluteGranulePosition += num6;
        } else {
            int num6 = dataBuffer.getLength() * 2 / (this.__inputFormat.getChannelCount() * 2);
            this._absoluteGranulePosition += num6;
        }
        Page page = new Page();
        page.setPayload(dataBuffer.toArray());
        page.setAbsoluteGranulePosition(this._absoluteGranulePosition);
        this.writePage(page);
        return true;
    }

    @Override
    protected void doWriteHeader() {
        if (this.__isOpus) {
            this.writeStreamHeaderOpus();
        } else if (this.__isPcm) {
            if (this.__inputFormat.getLittleEndian()) {
                this.writeStreamHeaderPcm(2L);
            } else {
                this.writeStreamHeaderPcm(3L);
            }
        } else if (this.__isPcmu) {
            this.writeStreamHeaderPcm(16L);
        } else if (this.__isPcma) {
            this.writeStreamHeaderPcm(17L);
        }
    }

    public String getArtist() {
        return this.__artist;
    }

    public String getTitle() {
        return this.__title;
    }

    public String getVendor() {
        return this.__vendor;
    }

    public void setArtist(String value) {
        this.__artist = value;
    }

    public void setTitle(String value) {
        this.__title = value;
    }

    public void setVendor(String value) {
        this.__vendor = value;
    }

    private void writePage(Page page) {
        page.setSequenceNumber(this._sequenceNumber++);
        page.setStreamSerialNumber(this._streamSerialNumber);
        if (super.getFile() != null) {
            super.getFileStream().write(page.getBytes());
        }
    }

    private void writeStreamHeaderOpus() {
        DataBufferStream stream = new DataBufferStream(19, true);
        stream.writeBytes(Encoding.getUtf8().getBytes("OpusHead"));
        stream.write8(1);
        stream.write8(this.__inputFormat.getChannelCount());
        stream.write16(0);
        stream.write32(this.__inputFormat.getClockRate());
        stream.write16(0);
        stream.write8(0);
        Page page = new Page();
        page.setAbsoluteGranulePosition(0);
        page.setBeginningOfStream(true);
        page.setPayload(stream.getBuffer().toArray());
        this.writePage(page);
        byte[] bytes = Encoding.getUtf8().getBytes(this.getVendor());
        Object[] strArray = new String[]{StringExtensions.concat("title=", this.getTitle()), StringExtensions.concat("artist=", this.getArtist())};
        int dataBufferSize = 16 + ArrayExtensions.getLength(bytes);
        for (Object str : strArray) {
            dataBufferSize += 4 + StringExtensions.getLength((String)str);
        }
        stream = new DataBufferStream(dataBufferSize, true);
        stream.writeBytes(Encoding.getUtf8().getBytes("OpusTags"));
        stream.write32(ArrayExtensions.getLength(bytes));
        stream.writeBytes(bytes);
        stream.write32(ArrayExtensions.getLength(strArray));
        for (Object str : strArray) {
            stream.write32(StringExtensions.getLength((String)str));
            stream.writeBytes(Encoding.getUtf8().getBytes((String)str));
        }
        Page page2 = new Page();
        page2.setAbsoluteGranulePosition(0);
        page2.setPayload(stream.getBuffer().toArray());
        this.writePage(page2);
    }

    private void writeStreamHeaderPcm(long pcmFormat) {
        DataBufferStream stream = new DataBufferStream(28, false);
        stream.writeBytes(Encoding.getUtf8().getBytes("PCM     "));
        stream.write16(0);
        stream.write16(0);
        stream.write32(pcmFormat);
        stream.write32(this.__inputFormat.getClockRate());
        stream.write8(0);
        stream.write8(this.__inputFormat.getChannelCount());
        stream.write16(0);
        stream.write32(0L);
        Page page = new Page();
        page.setAbsoluteGranulePosition(0);
        page.setBeginningOfStream(true);
        page.setPayload(stream.getBuffer().toArray());
        this.writePage(page);
        byte[] bytes = Encoding.getUtf8().getBytes(this.getVendor());
        stream = new DataBufferStream(8 + ArrayExtensions.getLength(bytes), false);
        stream.write32(ArrayExtensions.getLength(bytes));
        stream.writeBytes(bytes);
        stream.write32(0L);
        Page page2 = new Page();
        page2.setAbsoluteGranulePosition(0);
        page2.setPayload(stream.getBuffer().toArray());
        this.writePage(page2);
    }
}

