/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.NullableLong;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Element;

public class Video
extends Element {
    private NullableLong _displayHeight = new NullableLong();
    private static byte[] _displayHeightId;
    private long _displayUnit;
    private static byte[] _displayUnitId;
    private NullableLong _displayWidth = new NullableLong();
    private static byte[] _displayWidthId;
    private long _pixelCropBottom;
    private static byte[] _pixelCropBottomId;
    private long _pixelCropLeft;
    private static byte[] _pixelCropLeftId;
    private long _pixelCropRight;
    private static byte[] _pixelCropRightId;
    private long _pixelCropTop;
    private static byte[] _pixelCropTopId;
    private long _pixelHeight;
    private static byte[] _pixelHeightId;
    private long _pixelWidth;
    private static byte[] _pixelWidthId;

    public static long getDefaultDisplayUnit() {
        return 0L;
    }

    public static long getDefaultPixelCropBottom() {
        return 0L;
    }

    public static long getDefaultPixelCropLeft() {
        return 0L;
    }

    public static long getDefaultPixelCropRight() {
        return 0L;
    }

    public static long getDefaultPixelCropTop() {
        return 0L;
    }

    public NullableLong getDisplayHeight() {
        return this._displayHeight;
    }

    public long getDisplayUnit() {
        return this._displayUnit;
    }

    public NullableLong getDisplayWidth() {
        return this._displayWidth;
    }

    public static byte[] getEbmlId() {
        return new byte[]{-32};
    }

    @Override
    public byte[] getId() {
        return Video.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        super.writeUnsignedInteger(this.getPixelWidth(), _pixelWidthId, stream);
        super.writeUnsignedInteger(this.getPixelHeight(), _pixelHeightId, stream);
        if (super.getWriteDefaultValues() || this.getPixelCropBottom() != Video.getDefaultPixelCropBottom()) {
            super.writeUnsignedInteger(this.getPixelCropBottom(), _pixelCropBottomId, stream);
        }
        if (super.getWriteDefaultValues() || this.getPixelCropTop() != Video.getDefaultPixelCropTop()) {
            super.writeUnsignedInteger(this.getPixelCropTop(), _pixelCropTopId, stream);
        }
        if (super.getWriteDefaultValues() || this.getPixelCropLeft() != Video.getDefaultPixelCropLeft()) {
            super.writeUnsignedInteger(this.getPixelCropLeft(), _pixelCropLeftId, stream);
        }
        if (super.getWriteDefaultValues() || this.getPixelCropRight() != Video.getDefaultPixelCropRight()) {
            super.writeUnsignedInteger(this.getPixelCropRight(), _pixelCropRightId, stream);
        }
        if (super.getWriteDefaultValues() || this.getDisplayWidth().getHasValue()) {
            if (super.getWriteDefaultValues() && !this.getDisplayWidth().getHasValue()) {
                this.setDisplayWidth(new NullableLong(this.getPixelWidth()));
            }
            super.writeUnsignedInteger(this.getDisplayWidth().getValue(), _displayWidthId, stream);
        }
        if (super.getWriteDefaultValues() || this.getDisplayHeight().getHasValue()) {
            if (super.getWriteDefaultValues() && !this.getDisplayHeight().getHasValue()) {
                this.setDisplayHeight(new NullableLong(this.getPixelHeight()));
            }
            super.writeUnsignedInteger(this.getDisplayHeight().getValue(), _displayHeightId, stream);
        }
        if (super.getWriteDefaultValues() || this.getDisplayUnit() != Video.getDefaultDisplayUnit()) {
            super.writeUnsignedInteger(this.getDisplayUnit(), _displayUnitId, stream);
        }
        return stream.toArray();
    }

    public long getPixelCropBottom() {
        return this._pixelCropBottom;
    }

    public long getPixelCropLeft() {
        return this._pixelCropLeft;
    }

    public long getPixelCropRight() {
        return this._pixelCropRight;
    }

    public long getPixelCropTop() {
        return this._pixelCropTop;
    }

    public long getPixelHeight() {
        return this._pixelHeight;
    }

    public long getPixelWidth() {
        return this._pixelWidth;
    }

    public void setDisplayHeight(NullableLong value) {
        this._displayHeight = value;
    }

    public void setDisplayUnit(long value) {
        this._displayUnit = value;
    }

    public void setDisplayWidth(NullableLong value) {
        this._displayWidth = value;
    }

    public void setPixelCropBottom(long value) {
        this._pixelCropBottom = value;
    }

    public void setPixelCropLeft(long value) {
        this._pixelCropLeft = value;
    }

    public void setPixelCropRight(long value) {
        this._pixelCropRight = value;
    }

    public void setPixelCropTop(long value) {
        this._pixelCropTop = value;
    }

    public void setPixelHeight(long value) {
        this._pixelHeight = value;
    }

    public void setPixelWidth(long value) {
        this._pixelWidth = value;
    }

    public Video() {
        this.setPixelCropBottom(Video.getDefaultPixelCropBottom());
        this.setPixelCropTop(Video.getDefaultPixelCropTop());
        this.setPixelCropLeft(Video.getDefaultPixelCropLeft());
        this.setPixelCropRight(Video.getDefaultPixelCropRight());
        this.setDisplayUnit(Video.getDefaultDisplayUnit());
    }

    public Video(byte[] bytes) {
        this();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, _pixelWidthId)) {
                this.setPixelWidth(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _pixelHeightId)) {
                this.setPixelHeight(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _pixelCropBottomId)) {
                this.setPixelCropBottom(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _pixelCropTopId)) {
                this.setPixelCropTop(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _pixelCropLeftId)) {
                this.setPixelCropLeft(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _pixelCropRightId)) {
                this.setPixelCropRight(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _displayWidthId)) {
                this.setDisplayWidth(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _displayHeightId)) {
                this.setDisplayHeight(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _displayUnitId)) {
                this.setDisplayUnit(Element.readUnsignedInteger(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaVideo: ", BitAssistant.getHexString(buffer)));
        }
    }

    static {
        _pixelWidthId = new byte[]{-80};
        _pixelHeightId = new byte[]{-70};
        _pixelCropBottomId = new byte[]{84, -86};
        _pixelCropTopId = new byte[]{84, -69};
        _pixelCropLeftId = new byte[]{84, -52};
        _pixelCropRightId = new byte[]{84, -35};
        _displayWidthId = new byte[]{84, -80};
        _displayHeightId = new byte[]{84, -70};
        _displayUnitId = new byte[]{84, -78};
    }
}

