/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.NullableDate;
import fm.icelink.NullableFloat;
import fm.icelink.NullableGuid;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Element;

public class SegmentInfo
extends Element {
    private NullableDate _dateUtc = new NullableDate();
    private static byte[] _dateUtcId;
    private NullableFloat _duration = new NullableFloat();
    private static byte[] _durationId;
    private String _muxingApp;
    private static byte[] _muxingAppId;
    private String _nextFilename;
    private static byte[] _nextFilenameId;
    private NullableGuid _nextUid = new NullableGuid();
    private static byte[] _nextUidId;
    private String _prevFilename;
    private static byte[] _prevFilenameId;
    private NullableGuid _prevUid = new NullableGuid();
    private static byte[] _prevUidId;
    private String _segmentFilename;
    private static byte[] _segmentFilenameId;
    private NullableGuid _segmentUid = new NullableGuid();
    private static byte[] _segmentUidId;
    private long _timecodeScale;
    private static byte[] _timecodeScaleId;
    private String _title;
    private static byte[] _titleId;
    private String _writingApp;
    private static byte[] _writingAppId;

    public NullableDate getDateUtc() {
        return this._dateUtc;
    }

    public static long getDefaultTimecodeScale() {
        return 1000000L;
    }

    public NullableFloat getDuration() {
        return this._duration;
    }

    public static byte[] getEbmlId() {
        return new byte[]{21, 73, -87, 102};
    }

    @Override
    public byte[] getId() {
        return SegmentInfo.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (this.getSegmentUid().getHasValue()) {
            super.writeGuid(this.getSegmentUid().getValue(), _segmentUidId, stream);
        }
        if (this.getSegmentFilename() != null) {
            super.writeUtf8(this.getSegmentFilename(), _segmentFilenameId, stream);
        }
        if (this.getPrevUid().getHasValue()) {
            super.writeGuid(this.getPrevUid().getValue(), _prevUidId, stream);
        }
        if (this.getPrevFilename() != null) {
            super.writeUtf8(this.getPrevFilename(), _prevFilenameId, stream);
        }
        if (this.getNextUid().getHasValue()) {
            super.writeGuid(this.getNextUid().getValue(), _nextUidId, stream);
        }
        if (this.getNextFilename() != null) {
            super.writeUtf8(this.getNextFilename(), _nextFilenameId, stream);
        }
        if (super.getWriteDefaultValues() || this.getTimecodeScale() != SegmentInfo.getDefaultTimecodeScale()) {
            super.writeUnsignedInteger(this.getTimecodeScale(), _timecodeScaleId, stream);
        }
        if (this.getDuration().getHasValue()) {
            super.writeFloat(this.getDuration().getValue(), _durationId, stream);
        }
        if (this.getTitle() != null) {
            super.writeUtf8(this.getTitle(), _titleId, stream);
        }
        if (this.getMuxingApp() != null) {
            super.writeString(this.getMuxingApp(), _muxingAppId, stream);
        }
        if (this.getWritingApp() != null) {
            super.writeUtf8(this.getWritingApp(), _writingAppId, stream);
        }
        if (this.getDateUtc().getHasValue()) {
            super.writeDate(this.getDateUtc().getValue(), _dateUtcId, stream);
        }
        return stream.toArray();
    }

    public String getMuxingApp() {
        return this._muxingApp;
    }

    public String getNextFilename() {
        return this._nextFilename;
    }

    public NullableGuid getNextUid() {
        return this._nextUid;
    }

    public String getPrevFilename() {
        return this._prevFilename;
    }

    public NullableGuid getPrevUid() {
        return this._prevUid;
    }

    public String getSegmentFilename() {
        return this._segmentFilename;
    }

    public NullableGuid getSegmentUid() {
        return this._segmentUid;
    }

    public long getTimecodeScale() {
        return this._timecodeScale;
    }

    public String getTitle() {
        return this._title;
    }

    public String getWritingApp() {
        return this._writingApp;
    }

    public void merge(SegmentInfo segmentInfo) {
        if (segmentInfo != null && segmentInfo.getTimecodeScale() != this.getTimecodeScale()) {
            throw new RuntimeException(new Exception("Could not merge segment infos. Timecode scales do not match."));
        }
    }

    public SegmentInfo() {
        this.setTimecodeScale(SegmentInfo.getDefaultTimecodeScale());
    }

    public SegmentInfo(byte[] bytes) {
        this();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, _segmentUidId)) {
                this.setSegmentUid(new NullableGuid(Element.readGuid(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _segmentFilenameId)) {
                this.setSegmentFilename(Element.readUtf8(buffer2));
                continue;
            }
            if (Element.compare(buffer, _prevUidId)) {
                this.setPrevUid(new NullableGuid(Element.readGuid(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _prevFilenameId)) {
                this.setPrevFilename(Element.readUtf8(buffer2));
                continue;
            }
            if (Element.compare(buffer, _nextUidId)) {
                this.setNextUid(new NullableGuid(Element.readGuid(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _nextFilenameId)) {
                this.setNextFilename(Element.readUtf8(buffer2));
                continue;
            }
            if (Element.compare(buffer, _timecodeScaleId)) {
                this.setTimecodeScale(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _durationId)) {
                this.setDuration(new NullableFloat(Element.readFloat(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _titleId)) {
                this.setTitle(Element.readUtf8(buffer2));
                continue;
            }
            if (Element.compare(buffer, _muxingAppId)) {
                this.setMuxingApp(Element.readString(buffer2));
                continue;
            }
            if (Element.compare(buffer, _writingAppId)) {
                this.setWritingApp(Element.readUtf8(buffer2));
                continue;
            }
            if (Element.compare(buffer, _dateUtcId)) {
                this.setDateUtc(new NullableDate(Element.readDate(buffer2)));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaSegmentInfo: ", BitAssistant.getHexString(buffer)));
        }
    }

    public void setDateUtc(NullableDate value) {
        this._dateUtc = value;
    }

    public void setDuration(NullableFloat value) {
        this._duration = value;
    }

    public void setMuxingApp(String value) {
        this._muxingApp = value;
    }

    public void setNextFilename(String value) {
        this._nextFilename = value;
    }

    public void setNextUid(NullableGuid value) {
        this._nextUid = value;
    }

    public void setPrevFilename(String value) {
        this._prevFilename = value;
    }

    public void setPrevUid(NullableGuid value) {
        this._prevUid = value;
    }

    public void setSegmentFilename(String value) {
        this._segmentFilename = value;
    }

    public void setSegmentUid(NullableGuid value) {
        this._segmentUid = value;
    }

    public void setTimecodeScale(long value) {
        this._timecodeScale = value;
    }

    public void setTitle(String value) {
        this._title = value;
    }

    public void setWritingApp(String value) {
        this._writingApp = value;
    }

    static {
        _segmentUidId = new byte[]{115, -92};
        _segmentFilenameId = new byte[]{115, -124};
        _prevUidId = new byte[]{60, -71, 35};
        _prevFilenameId = new byte[]{60, -125, -85};
        _nextUidId = new byte[]{62, -71, 35};
        _nextFilenameId = new byte[]{62, -125, -69};
        _timecodeScaleId = new byte[]{42, -41, -79};
        _durationId = new byte[]{68, -119};
        _titleId = new byte[]{123, -87};
        _muxingAppId = new byte[]{77, -128};
        _writingAppId = new byte[]{87, 65};
        _dateUtcId = new byte[]{68, 97};
    }
}

