/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Element;
import fm.icelink.matroska.Seek;
import java.util.ArrayList;

public class SeekHead
extends Element {
    private Seek[] _seeks;

    public static byte[] getEbmlId() {
        return new byte[]{17, 77, -101, 116};
    }

    @Override
    public byte[] getId() {
        return SeekHead.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (this.getSeeks() != null) {
            for (Seek seek : this.getSeeks()) {
                stream.writeBuffer(seek.getBytes());
            }
        }
        return stream.toArray();
    }

    public Seek[] getSeeks() {
        return this._seeks;
    }

    public SeekHead(byte[] bytes) {
        this();
        ArrayList<Seek> list = new ArrayList<Seek>();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, Seek.getEbmlId())) {
                list.add(new Seek(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaSeekHead: ", BitAssistant.getHexString(buffer)));
        }
        if (ArrayListExtensions.getCount(list) > 0) {
            this.setSeeks(list.toArray(new Seek[0]));
        }
    }

    public SeekHead() {
    }

    public void setSeeks(Seek[] value) {
        this._seeks = value;
    }
}

