/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Element;

public class Seek
extends Element {
    private long _seekId;
    private static byte[] _seekIdId = new byte[]{83, -85};
    private long _seekPosition;
    private static byte[] _seekPositionId = new byte[]{83, -84};

    public static byte[] getEbmlId() {
        return new byte[]{77, -69};
    }

    @Override
    public byte[] getId() {
        return Seek.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        super.writeUnsignedInteger(this.getSeekId(), _seekIdId, stream);
        super.writeUnsignedInteger(this.getSeekPosition(), _seekPositionId, stream);
        return stream.toArray();
    }

    public long getSeekId() {
        return this._seekId;
    }

    public long getSeekPosition() {
        return this._seekPosition;
    }

    public Seek() {
    }

    public Seek(byte[] bytes) {
        this();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, _seekIdId)) {
                this.setSeekId(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _seekPositionId)) {
                this.setSeekPosition(Element.readUnsignedInteger(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaSeek: ", BitAssistant.getHexString(buffer)));
        }
    }

    public void setSeekId(long value) {
        this._seekId = value;
    }

    public void setSeekPosition(long value) {
        this._seekPosition = value;
    }
}

