/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.DateExtensions;
import fm.icelink.Encoding;
import fm.icelink.Guid;
import fm.icelink.IntegerHolder;
import java.util.Date;

public abstract class Element {
    private static long[] _dataBitsMask;
    private int _length;
    private static Date _relativeDateUtc;
    private int _size;
    private int _sizeLength;
    private static int _ticksPerNano;
    private boolean _writeDefaultValues;

    public static boolean compare(byte[] bytes1, byte[] bytes2) {
        if (bytes1 != null || bytes2 != null) {
            if (bytes1 == null || bytes2 == null) {
                return false;
            }
            if (ArrayExtensions.getLength(bytes1) != ArrayExtensions.getLength(bytes2)) {
                return false;
            }
            for (int i = 0; i < ArrayExtensions.getLength(bytes1); ++i) {
                if (bytes1[i] == bytes2[i]) continue;
                return false;
            }
        }
        return true;
    }

    protected Element() {
    }

    public byte[] getBytes() {
        int sizeLength = this.getSizeLength();
        this.setSizeLength(0);
        byte[] innerBytes = this.getInnerBytes();
        this.setSizeLength(sizeLength);
        ByteOutputStream stream = new ByteOutputStream();
        this.setSize(ArrayExtensions.getLength(innerBytes));
        this.write(innerBytes, this.getId(), stream);
        this.setLength(stream.getSize());
        return stream.toArray();
    }

    public abstract byte[] getId();

    protected abstract byte[] getInnerBytes();

    public int getLength() {
        return this._length;
    }

    public int getSize() {
        return this._size;
    }

    public int getSizeLength() {
        return this._sizeLength;
    }

    public boolean getWriteDefaultValues() {
        return this._writeDefaultValues;
    }

    public static boolean readBool(byte[] value) {
        return Element.readUnsignedInteger(value) == 1L;
    }

    public static Date readDate(byte[] value) {
        long num = Binary.fromBytes64(value, 0, false);
        return DateExtensions.createDate(DateExtensions.getTicks(_relativeDateUtc) + num / (long)_ticksPerNano);
    }

    public static double readDouble(byte[] value) {
        return Binary.fromBytes64(value, 0, false);
    }

    public static float readFloat(byte[] value) {
        return Binary.fromBytes32(value, 0, false);
    }

    public static Guid readGuid(byte[] value) {
        return new Guid(value);
    }

    public static byte[] readId(byte[] bytes, int offset, IntegerHolder offsetPlus) {
        int count = 0;
        byte num2 = bytes[offset];
        if ((num2 & 0x80) == 128) {
            count = 1;
        } else if ((num2 & 0xC0) == 64) {
            count = 2;
        } else if ((num2 & 0xE0) == 32) {
            count = 3;
        } else if ((num2 & 0xF0) == 16) {
            count = 4;
        }
        offsetPlus.setValue(offset);
        if (count > 0) {
            offsetPlus.setValue(offsetPlus.getValue() + count);
            return BitAssistant.subArray(bytes, offset, count);
        }
        return null;
    }

    public static long readSignedInteger(byte[] value) {
        long num3;
        if (ArrayExtensions.getLength(value) == 1) {
            byte num = value[0];
            if (num > 127) {
                return ~num;
            }
        } else if (ArrayExtensions.getLength(value) == 2) {
            int num2 = Binary.fromBytes16(value, 0, false);
            if (num2 > Short.MAX_VALUE) {
                return ~num2;
            }
        } else if (ArrayExtensions.getLength(value) == 3) {
            int num2 = Binary.fromBytes24(value, 0, false);
            if (num2 > 0x7FFFFF) {
                return ~num2;
            }
        } else if (ArrayExtensions.getLength(value) == 4) {
            long num32 = Binary.fromBytes32(value, 0, false);
            if (num32 > Integer.MAX_VALUE) {
                return num32 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else if (ArrayExtensions.getLength(value) == 5) {
            long num33 = Binary.fromBytes40(value, 0, false);
            if (num33 > 0x7FFFFFFFFFL) {
                return num33 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else if (ArrayExtensions.getLength(value) == 6) {
            long num34 = Binary.fromBytes48(value, 0, false);
            if (num34 > 0x7FFFFFFFFFFFL) {
                return num34 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else if (ArrayExtensions.getLength(value) == 7) {
            long num35 = Binary.fromBytes56(value, 0, false);
            if (num35 > 0x7FFFFFFFFFFFFFL) {
                return num35 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else if (ArrayExtensions.getLength(value) == 8 && (num3 = Binary.fromBytes64(value, 0, false)) > Long.MAX_VALUE) {
            return num3 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return 0L;
    }

    public static String readString(byte[] value) {
        return Encoding.getUtf8().getString(value, 0, ArrayExtensions.getLength(value));
    }

    public static long readUnsignedInteger(byte[] value) {
        if (ArrayExtensions.getLength(value) == 1) {
            return value[0];
        }
        if (ArrayExtensions.getLength(value) == 2) {
            return Binary.fromBytes16(value, 0, false);
        }
        if (ArrayExtensions.getLength(value) == 3) {
            return Binary.fromBytes24(value, 0, false);
        }
        if (ArrayExtensions.getLength(value) == 4) {
            return Binary.fromBytes32(value, 0, false);
        }
        if (ArrayExtensions.getLength(value) == 5) {
            return Binary.fromBytes40(value, 0, false);
        }
        if (ArrayExtensions.getLength(value) == 6) {
            return Binary.fromBytes48(value, 0, false);
        }
        if (ArrayExtensions.getLength(value) == 7) {
            return Binary.fromBytes56(value, 0, false);
        }
        if (ArrayExtensions.getLength(value) == 8) {
            return Binary.fromBytes64(value, 0, false);
        }
        return 0L;
    }

    public static String readUtf8(byte[] value) {
        return Encoding.getUtf8().getString(value, 0, ArrayExtensions.getLength(value));
    }

    public static byte[] readValue(byte[] bytes, int offset, IntegerHolder offsetPlus) {
        long num = -1L;
        byte num2 = bytes[offset];
        if ((num2 & 0x80) == 128) {
            num = num2 & 0x7F;
            ++offset;
        } else if ((num2 & 0xC0) == 64) {
            num = Binary.fromBytes16(bytes, offset, false) & 0x3FFF;
            offset += 2;
        } else if ((num2 & 0xE0) == 32) {
            num = Binary.fromBytes24(bytes, offset, false) & 0x1FFFFF;
            offset += 3;
        } else if ((num2 & 0xF0) == 16) {
            num = Binary.fromBytes32(bytes, offset, false) & 0xFFFFFFFL;
            offset += 4;
        } else if ((num2 & 0xF8) == 8) {
            num = Binary.fromBytes40(bytes, offset, false) & 0x7FFFFFFFFL;
            offset += 5;
        } else if ((num2 & 0xFC) == 4) {
            num = Binary.fromBytes48(bytes, offset, false) & 0x3FFFFFFFFFFL;
            offset += 6;
        } else if ((num2 & 0xFE) == 2) {
            num = Binary.fromBytes56(bytes, offset, false) & 0x1FFFFFFFFFFFFL;
            offset += 7;
        } else if ((num2 & 0xFF) == 1) {
            num = Binary.fromBytes64(bytes, offset, false) & 0xFFFFFFFFFFFFFFL;
            offset += 8;
        }
        offsetPlus.setValue(offset);
        if (num >= 0L) {
            offsetPlus.setValue(offsetPlus.getValue() + (int)num);
            return BitAssistant.subArray(bytes, offset, (int)num);
        }
        return null;
    }

    public static long readVariableInteger(byte[] bytes, int offset, IntegerHolder offsetPlus) {
        long num = 0L;
        int count = 0;
        byte num3 = bytes[offset];
        if ((num3 & 0x80) == 128) {
            count = 1;
            num = bytes[offset] & 0x7F;
        } else if ((num3 & 0xC0) == 64) {
            count = 2;
            byte[] buffer = BitAssistant.subArray(bytes, offset, count);
            buffer[0] = (byte)(buffer[0] & 0x3F);
            num = Binary.fromBytes16(buffer, 0, false);
        } else if ((num3 & 0xE0) == 32) {
            count = 3;
            byte[] buffer = BitAssistant.subArray(bytes, offset, count);
            buffer[0] = (byte)(buffer[0] & 0x1F);
            num = Binary.fromBytes24(buffer, 0, false);
        } else if ((num3 & 0xF0) == 16) {
            count = 4;
            byte[] buffer = BitAssistant.subArray(bytes, offset, count);
            buffer[0] = (byte)(buffer[0] & 0xF);
            num = Binary.fromBytes32(buffer, 0, false);
        }
        offsetPlus.setValue(offset + count);
        return num;
    }

    public static byte[] serializeVariableInteger(long value) {
        return Element.serializeVariableInteger(value, 0);
    }

    public static byte[] serializeVariableInteger(long value, int length) {
        if (length == 0) {
            length = 1;
            while (_dataBitsMask[length] <= value) {
                ++length;
            }
        }
        long num = BitAssistant.leftShiftLong(1L, 7 * length);
        long num2 = value | num;
        byte[] buffer = new byte[length];
        long num3 = num2;
        for (int i = length - 1; i >= 0; --i) {
            buffer[i] = (byte)(num3 & 0xFFL);
            num3 = BitAssistant.rightShiftLong(num3, 8);
        }
        return buffer;
    }

    private void setLength(int value) {
        this._length = value;
    }

    private void setSize(int value) {
        this._size = value;
    }

    public void setSizeLength(int value) {
        this._sizeLength = value;
    }

    public void setWriteDefaultValues(boolean value) {
        this._writeDefaultValues = value;
    }

    protected void write(byte[] value, byte[] id, ByteOutputStream stream) {
        stream.writeBuffer(id);
        this.writeVariableInteger(ArrayExtensions.getLength(value), stream, this.getSizeLength());
        stream.writeBuffer(value);
    }

    protected void writeBool(boolean value, byte[] id, ByteOutputStream stream) {
        this.writeUnsignedInteger(value ? 1L : 0L, id, stream);
    }

    protected void writeDate(Date value, byte[] id, ByteOutputStream stream) {
        long num = (DateExtensions.getTicks(value) - DateExtensions.getTicks(_relativeDateUtc)) * (long)_ticksPerNano;
        this.write(Binary.toBytes64(num, false), id, stream);
    }

    protected void writeDouble(double value, byte[] id, ByteOutputStream stream) {
        this.write(Binary.toBytes64((long)value, false), id, stream);
    }

    protected void writeFloat(float value, byte[] id, ByteOutputStream stream) {
        this.write(Binary.toBytes32((long)value, false), id, stream);
    }

    protected void writeGuid(Guid value, byte[] id, ByteOutputStream stream) {
        this.write(value.toByteArray(), id, stream);
    }

    protected void writeSignedInteger(long value, byte[] id, ByteOutputStream stream) {
        int num;
        long i;
        long num2 = 0xFFFFFF80L;
        long l = i = value < 0L ? num2 : 0L;
        for (num = value == 0L ? 0 : 1; num < 8 && (num2 & value) != i; ++num) {
            num2 = BitAssistant.leftShiftLong(num2, 8);
            i = BitAssistant.leftShiftLong(i, 8);
        }
        byte[] buffer = new byte[num];
        long num4 = value;
        for (int j = num - 1; j >= 0; --j) {
            buffer[j] = (byte)(num4 & 0xFFL);
            num4 = BitAssistant.rightShiftLong(num4, 8);
        }
        this.write(buffer, id, stream);
    }

    protected void writeString(String value, byte[] id, ByteOutputStream stream) {
        this.write(Encoding.getUtf8().getBytes(value), id, stream);
    }

    protected void writeUnsignedInteger(long value, byte[] id, ByteOutputStream stream) {
        int num;
        long i = Long.MAX_VALUE;
        for (num = 0; (value & i) != 0L && num < 8; ++num) {
            i = BitAssistant.leftShiftLong(i, 8);
        }
        byte[] buffer = new byte[num];
        long num3 = value;
        for (int j = num - 1; j >= 0; --j) {
            buffer[j] = (byte)(num3 & 0xFFL);
            num3 = BitAssistant.rightShiftLong(num3, 8);
        }
        this.write(buffer, id, stream);
    }

    protected void writeUtf8(String value, byte[] id, ByteOutputStream stream) {
        this.write(Encoding.getUtf8().getBytes(value), id, stream);
    }

    protected void writeVariableInteger(long value, ByteOutputStream stream, int length) {
        byte[] buffer = Element.serializeVariableInteger(value, length);
        stream.writeBuffer(buffer, 0, ArrayExtensions.getLength(buffer));
    }

    protected void writeVariableInteger(long value, ByteOutputStream stream) {
        this.writeVariableInteger(value, stream, 0);
    }

    static {
        _relativeDateUtc = new Date();
        _dataBitsMask = new long[]{BitAssistant.leftShiftLong(1L, 0) - 1L, BitAssistant.leftShiftLong(1L, 7) - 1L, BitAssistant.leftShiftLong(1L, 14) - 1L, BitAssistant.leftShiftLong(1L, 21) - 1L, BitAssistant.leftShiftLong(1L, 28) - 1L, BitAssistant.leftShiftLong(1L, 35) - 1L, BitAssistant.leftShiftLong(1L, 42) - 1L, BitAssistant.leftShiftLong(1L, 49) - 1L, BitAssistant.leftShiftLong(1L, 56) - 1L};
        _relativeDateUtc = DateExtensions.createDate(2001, 1, 1, 0, 0, 0);
        _ticksPerNano = 100;
    }
}

