/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.ContentEncoding;
import fm.icelink.matroska.Element;
import java.util.ArrayList;

public class ContentEncodings
extends Element {
    private ContentEncoding[] _contentEncodingElements;

    public ContentEncodings(byte[] bytes) {
        this();
        ArrayList<ContentEncoding> list = new ArrayList<ContentEncoding>();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, ContentEncoding.getEbmlId())) {
                list.add(new ContentEncoding(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaContentEncodings: ", BitAssistant.getHexString(buffer)));
        }
        if (ArrayListExtensions.getCount(list) > 0) {
            this.setContentEncodingElements(list.toArray(new ContentEncoding[0]));
        }
    }

    public ContentEncodings() {
    }

    public ContentEncoding[] getContentEncodingElements() {
        return this._contentEncodingElements;
    }

    public static byte[] getEbmlId() {
        return new byte[]{109, -128};
    }

    @Override
    public byte[] getId() {
        return ContentEncodings.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (this.getContentEncodingElements() != null) {
            for (ContentEncoding encoding : this.getContentEncodingElements()) {
                stream.writeBuffer(encoding.getBytes());
            }
        }
        return stream.toArray();
    }

    public void setContentEncodingElements(ContentEncoding[] value) {
        this._contentEncodingElements = value;
    }
}

