/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.NullableLong;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Block;
import fm.icelink.matroska.BlockGroup;
import fm.icelink.matroska.Element;
import fm.icelink.matroska.SimpleBlock;
import java.util.ArrayList;

public class Cluster
extends Element {
    private BlockGroup[] _blockGroups;
    private NullableLong _position = new NullableLong();
    private static byte[] _positionId;
    private NullableLong _prevSize = new NullableLong();
    private static byte[] _prevSizeId;
    private SimpleBlock[] _simpleBlocks;
    private long _timecode;
    private static byte[] _timecodeId;

    public Cluster() {
    }

    public Cluster(byte[] bytes) {
        ArrayList<BlockGroup> list = new ArrayList<BlockGroup>();
        ArrayList<SimpleBlock> list2 = new ArrayList<SimpleBlock>();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, _timecodeId)) {
                this.setTimecode(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _positionId)) {
                this.setPosition(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _prevSizeId)) {
                this.setPrevSize(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            if (Element.compare(buffer, BlockGroup.getEbmlId())) {
                list.add(new BlockGroup(buffer2));
                continue;
            }
            if (Element.compare(buffer, SimpleBlock.getEbmlId())) {
                list2.add(new SimpleBlock(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaCluster: ", BitAssistant.getHexString(buffer)));
        }
        if (ArrayListExtensions.getCount(list) > 0) {
            this.setBlockGroups(list.toArray(new BlockGroup[0]));
        }
        if (ArrayListExtensions.getCount(list2) > 0) {
            this.setSimpleBlocks(list2.toArray(new SimpleBlock[0]));
        }
    }

    public BlockGroup[] getBlockGroups() {
        return this._blockGroups;
    }

    public static long getDefaultTimecode() {
        return 0L;
    }

    public static byte[] getEbmlId() {
        return new byte[]{31, 67, -74, 117};
    }

    @Override
    public byte[] getId() {
        return Cluster.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        super.writeUnsignedInteger(this.getTimecode(), _timecodeId, stream);
        if (this.getPosition().getHasValue()) {
            super.writeUnsignedInteger(this.getPosition().getValue(), _positionId, stream);
        }
        if (this.getPrevSize().getHasValue()) {
            super.writeUnsignedInteger(this.getPrevSize().getValue(), _prevSizeId, stream);
        }
        if (this.getBlockGroups() != null) {
            for (Element element : this.getBlockGroups()) {
                stream.writeBuffer(element.getBytes());
            }
        }
        if (this.getSimpleBlocks() != null) {
            for (Element element : this.getSimpleBlocks()) {
                stream.writeBuffer(element.getBytes());
            }
        }
        return stream.toArray();
    }

    public NullableLong getPosition() {
        return this._position;
    }

    public NullableLong getPrevSize() {
        return this._prevSize;
    }

    public SimpleBlock[] getSimpleBlocks() {
        return this._simpleBlocks;
    }

    public long getTimecode() {
        return this._timecode;
    }

    public void merge(Cluster cluster) {
        if (cluster != null) {
            int num2;
            int num;
            if (cluster.getBlockGroups() != null) {
                for (Element element : cluster.getBlockGroups()) {
                    Block block1 = ((BlockGroup)element).getBlock();
                    block1.setTimecode(block1.getTimecode() + (int)(this.getTimecode() - cluster.getTimecode()));
                }
            }
            if (cluster.getSimpleBlocks() != null) {
                for (Element element : cluster.getSimpleBlocks()) {
                    ((Block)element).setTimecode(((Block)element).getTimecode() + (int)(this.getTimecode() - cluster.getTimecode()));
                }
            }
            if (this.getBlockGroups() == null) {
                this.setBlockGroups(cluster.getBlockGroups());
            } else if (cluster.getBlockGroups() != null) {
                ArrayList<BlockGroup> list = new ArrayList<BlockGroup>();
                num = 0;
                num2 = 0;
                while (num < ArrayExtensions.getLength(this.getBlockGroups()) || num2 < ArrayExtensions.getLength(cluster.getBlockGroups())) {
                    BlockGroup item = null;
                    BlockGroup group3 = null;
                    if (num < ArrayExtensions.getLength(this.getBlockGroups())) {
                        item = this.getBlockGroups()[num];
                    }
                    if (num2 < ArrayExtensions.getLength(cluster.getBlockGroups())) {
                        group3 = cluster.getBlockGroups()[num2];
                    }
                    if (item != null && group3 != null) {
                        if (item.getBlock().getTimecode() <= group3.getBlock().getTimecode()) {
                            list.add(item);
                            ++num;
                            continue;
                        }
                        list.add(group3);
                        ++num2;
                        continue;
                    }
                    if (item != null) {
                        list.add(item);
                        ++num;
                        continue;
                    }
                    if (group3 == null) continue;
                    list.add(group3);
                    ++num2;
                }
                this.setBlockGroups(list.toArray(new BlockGroup[0]));
            }
            if (this.getSimpleBlocks() == null) {
                this.setSimpleBlocks(cluster.getSimpleBlocks());
            } else if (cluster.getSimpleBlocks() != null) {
                ArrayList<SimpleBlock> list2 = new ArrayList<SimpleBlock>();
                num = 0;
                num2 = 0;
                while (num < ArrayExtensions.getLength(this.getSimpleBlocks()) || num2 < ArrayExtensions.getLength(cluster.getSimpleBlocks())) {
                    SimpleBlock block2 = null;
                    SimpleBlock block3 = null;
                    if (num < ArrayExtensions.getLength(this.getSimpleBlocks())) {
                        block2 = this.getSimpleBlocks()[num];
                    }
                    if (num2 < ArrayExtensions.getLength(cluster.getSimpleBlocks())) {
                        block3 = cluster.getSimpleBlocks()[num2];
                    }
                    if (block2 != null && block3 != null) {
                        if (block2.getTimecode() <= block3.getTimecode()) {
                            list2.add(block2);
                            ++num;
                            continue;
                        }
                        list2.add(block3);
                        ++num2;
                        continue;
                    }
                    if (block2 != null) {
                        list2.add(block2);
                        ++num;
                        continue;
                    }
                    if (block3 == null) continue;
                    list2.add(block3);
                    ++num2;
                }
                this.setSimpleBlocks(list2.toArray(new SimpleBlock[0]));
            }
        }
    }

    public void setBlockGroups(BlockGroup[] value) {
        this._blockGroups = value;
    }

    public void setPosition(NullableLong value) {
        this._position = value;
    }

    public void setPrevSize(NullableLong value) {
        this._prevSize = value;
    }

    public void setSimpleBlocks(SimpleBlock[] value) {
        this._simpleBlocks = value;
    }

    public void setTimecode(long value) {
        this._timecode = value;
    }

    static {
        _timecodeId = new byte[]{-25};
        _positionId = new byte[]{-89};
        _prevSizeId = new byte[]{-85};
    }
}

