/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.h264;

import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.LongHolder;
import fm.icelink.MathAssistant;
import fm.icelink.h264.Nalu;
import fm.icelink.h264.Packet;
import java.util.ArrayList;

public class Frame {
    private static int __maxAge = 2;
    private int _age = 0;
    private ArrayList<Packet> _packets = new ArrayList();

    public void add(Packet packet) {
        for (int i = 0; i < ArrayListExtensions.getCount(this._packets); ++i) {
            Packet packet2 = ArrayListExtensions.getItem(this._packets).get(i);
            if (packet.getSequenceNumber() >= packet2.getSequenceNumber()) continue;
            ArrayListExtensions.insert(this._packets, i, packet);
            return;
        }
        this._packets.add(packet);
    }

    public DataBuffer assemble(LongHolder sequenceNumber) {
        DataBuffer empty = DataBuffer.getEmpty();
        sequenceNumber.setValue(0L);
        for (Packet packet : this._packets) {
            sequenceNumber.setValue(MathAssistant.max(packet.getSequenceNumber(), sequenceNumber.getValue()));
            for (Nalu nalu : packet.getNalus()) {
                if (packet.getNaluType() != 28 && packet.getNaluType() != 29 || packet.getFragmentStart()) {
                    empty.append(Nalu.getStartCode());
                    empty.append(nalu.getBytes());
                    continue;
                }
                if (packet.getNaluType() != 28 && packet.getNaluType() == 29) continue;
                empty.append(nalu.getPayload());
            }
        }
        return empty;
    }

    public Frame(Packet packet) {
        this.add(packet);
    }

    public boolean getIsAged() {
        return this._age >= Frame.getMaxAge();
    }

    public boolean getIsComplete() {
        if (!ArrayListExtensions.getItem(this._packets).get(ArrayListExtensions.getCount(this._packets) - 1).getLast()) {
            return false;
        }
        long sequenceNumber = -1L;
        for (Packet packet : this._packets) {
            if (sequenceNumber == -1L) {
                sequenceNumber = packet.getSequenceNumber();
                continue;
            }
            if (++sequenceNumber == packet.getSequenceNumber()) continue;
            return false;
        }
        return true;
    }

    public static int getMaxAge() {
        return __maxAge;
    }

    public void increaseAge() {
        ++this._age;
    }

    public static void setMaxAge(int value) {
        __maxAge = value;
    }
}

