/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1Any;
import fm.icelink.Asn1GeneralizedTime;
import fm.icelink.Asn1UtcTime;
import fm.icelink.DateExtensions;
import fm.icelink.Global;
import fm.icelink.X509TimeType;
import java.util.Date;

class X509Time {
    private X509TimeType _type;
    private Date _value = new Date();

    public static X509Time fromAsn1(Asn1Any any) {
        Asn1UtcTime time = Global.tryCast(any, Asn1UtcTime.class);
        if (time != null) {
            return new X509Time(time.getValue(), X509TimeType.Utc);
        }
        Asn1GeneralizedTime time2 = Global.tryCast(any, Asn1GeneralizedTime.class);
        if (time2 != null) {
            return new X509Time(time2.getValue(), X509TimeType.Generalized);
        }
        return null;
    }

    public X509TimeType getType() {
        return this._type;
    }

    public Date getValue() {
        return this._value;
    }

    public void setType(X509TimeType value) {
        this._type = value;
    }

    public void setValue(Date value) {
        this._value = value;
    }

    public Asn1Any toAsn1() {
        if (Global.equals((Object)this.getType(), (Object)X509TimeType.Utc)) {
            return new Asn1UtcTime(this.getValue());
        }
        if (Global.equals((Object)this.getType(), (Object)X509TimeType.Generalized)) {
            return new Asn1GeneralizedTime(this.getValue());
        }
        return null;
    }

    public X509Time(Date value, X509TimeType type) {
        this.setValue(value);
        this.setType(type);
    }

    public X509Time() {
        this(DateExtensions.getUtcNow(), X509TimeType.Utc);
    }
}

