/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1BitString;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import fm.icelink.X509AlgorithmIdentifier;

class X509SubjectPublicKeyInfo {
    private X509AlgorithmIdentifier _algorithm;
    private byte[] _subjectPublicKey;

    public static X509SubjectPublicKeyInfo fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 2) {
            return null;
        }
        X509SubjectPublicKeyInfo info = new X509SubjectPublicKeyInfo();
        info.setAlgorithm(X509AlgorithmIdentifier.fromAsn1(sequence.getValues()[0]));
        info.setSubjectPublicKey(((Asn1BitString)sequence.getValues()[1]).getValueBytes());
        return info;
    }

    public X509AlgorithmIdentifier getAlgorithm() {
        return this._algorithm;
    }

    public byte[] getSubjectPublicKey() {
        return this._subjectPublicKey;
    }

    public void setAlgorithm(X509AlgorithmIdentifier value) {
        this._algorithm = value;
    }

    public void setSubjectPublicKey(byte[] value) {
        this._subjectPublicKey = value;
    }

    public Asn1Sequence toAsn1() {
        return new Asn1Sequence(new Asn1Any[]{this.getAlgorithm().toAsn1(), new Asn1BitString(this.getSubjectPublicKey())});
    }
}

