/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Integer;
import fm.icelink.Asn1Sequence;
import fm.icelink.BitAssistant;
import fm.icelink.Global;

class X509RsaPrivateKey {
    private byte[] __coefficient = null;
    private byte[] __exponent1 = null;
    private byte[] __exponent2 = null;
    private byte[] __modulus = null;
    private byte[] __prime1 = null;
    private byte[] __prime2 = null;
    private byte[] __privateExponent = null;
    private byte[] __publicExponent = null;
    private int _version;

    public static X509RsaPrivateKey fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) != 9) {
            return null;
        }
        X509RsaPrivateKey key = new X509RsaPrivateKey();
        key.setVersion((int)((Asn1Integer)sequence.getValues()[0]).getLongValue());
        key.setModulus(((Asn1Integer)sequence.getValues()[1]).getValue());
        key.setPublicExponent(((Asn1Integer)sequence.getValues()[2]).getValue());
        key.setPrivateExponent(((Asn1Integer)sequence.getValues()[3]).getValue());
        key.setPrime1(((Asn1Integer)sequence.getValues()[4]).getValue());
        key.setPrime2(((Asn1Integer)sequence.getValues()[5]).getValue());
        key.setExponent1(((Asn1Integer)sequence.getValues()[6]).getValue());
        key.setExponent2(((Asn1Integer)sequence.getValues()[7]).getValue());
        key.setCoefficient(((Asn1Integer)sequence.getValues()[8]).getValue());
        return key;
    }

    public byte[] getCoefficient() {
        return X509RsaPrivateKey.trim(this.__coefficient);
    }

    public byte[] getExponent1() {
        return X509RsaPrivateKey.trim(this.__exponent1);
    }

    public byte[] getExponent2() {
        return X509RsaPrivateKey.trim(this.__exponent2);
    }

    public byte[] getModulus() {
        return X509RsaPrivateKey.trim(this.__modulus);
    }

    public byte[] getPrime1() {
        return X509RsaPrivateKey.trim(this.__prime1);
    }

    public byte[] getPrime2() {
        return X509RsaPrivateKey.trim(this.__prime2);
    }

    public byte[] getPrivateExponent() {
        return X509RsaPrivateKey.trim(this.__privateExponent);
    }

    public byte[] getPublicExponent() {
        return this.__publicExponent;
    }

    public int getVersion() {
        return this._version;
    }

    private static byte[] lengthen(byte[] block) {
        if (block == null) {
            return null;
        }
        if (ArrayExtensions.getLength(block) % 2 == 0) {
            byte[] destination = new byte[ArrayExtensions.getLength(block) + 1];
            destination[0] = 0;
            BitAssistant.copy(block, 0, destination, 1, ArrayExtensions.getLength(block));
            block = destination;
        }
        return block;
    }

    public void setCoefficient(byte[] value) {
        this.__coefficient = X509RsaPrivateKey.lengthen(value);
    }

    public void setExponent1(byte[] value) {
        this.__exponent1 = X509RsaPrivateKey.lengthen(value);
    }

    public void setExponent2(byte[] value) {
        this.__exponent2 = X509RsaPrivateKey.lengthen(value);
    }

    public void setModulus(byte[] value) {
        this.__modulus = X509RsaPrivateKey.lengthen(value);
    }

    public void setPrime1(byte[] value) {
        this.__prime1 = X509RsaPrivateKey.lengthen(value);
    }

    public void setPrime2(byte[] value) {
        this.__prime2 = X509RsaPrivateKey.lengthen(value);
    }

    public void setPrivateExponent(byte[] value) {
        this.__privateExponent = X509RsaPrivateKey.lengthen(value);
    }

    public void setPublicExponent(byte[] value) {
        this.__publicExponent = value;
    }

    public void setVersion(int value) {
        this._version = value;
    }

    public Asn1Sequence toAsn1() {
        return new Asn1Sequence(new Asn1Any[]{new Asn1Integer(this.getVersion()), new Asn1Integer(this.__modulus), new Asn1Integer(this.__publicExponent), new Asn1Integer(this.__privateExponent), new Asn1Integer(this.__prime1), new Asn1Integer(this.__prime2), new Asn1Integer(this.__exponent1), new Asn1Integer(this.__exponent2), new Asn1Integer(this.__coefficient)});
    }

    private static byte[] trim(byte[] block) {
        if (block == null) {
            return null;
        }
        if (ArrayExtensions.getLength(block) % 2 == 1 && block[0] == 0) {
            block = BitAssistant.subArray(block, 1);
        }
        return block;
    }

    public X509RsaPrivateKey(byte[] modulus, byte[] publicExponent, byte[] privateExponent, byte[] prime1, byte[] prime2, byte[] exponent1, byte[] exponent2, byte[] coefficient) {
        this();
        this.setModulus(modulus);
        this.setPublicExponent(publicExponent);
        this.setPrivateExponent(privateExponent);
        this.setPrime1(prime1);
        this.setPrime2(prime2);
        this.setExponent1(exponent1);
        this.setExponent2(exponent2);
        this.setCoefficient(coefficient);
    }

    public X509RsaPrivateKey() {
        this.setVersion(0);
    }
}

