/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Boolean;
import fm.icelink.Asn1ObjectIdentifier;
import fm.icelink.Asn1OctetString;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import java.util.ArrayList;

class X509Extension
extends Asn1Sequence {
    private boolean _critical;
    private long[] _extensionId;
    private byte[] _extensionValue;

    public static X509Extension fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 2) {
            return null;
        }
        X509Extension extension = new X509Extension();
        if (ArrayExtensions.getLength(sequence.getValues()) < 3) {
            extension.setExtensionId(((Asn1ObjectIdentifier)sequence.getValues()[0]).getValues());
            extension.setExtensionValue(((Asn1OctetString)sequence.getValues()[1]).getValueBytes());
        } else {
            extension.setExtensionId(((Asn1ObjectIdentifier)sequence.getValues()[0]).getValues());
            extension.setCritical(((Asn1Boolean)sequence.getValues()[1]).getValue());
            extension.setExtensionValue(((Asn1OctetString)sequence.getValues()[2]).getValueBytes());
        }
        return extension;
    }

    public boolean getCritical() {
        return this._critical;
    }

    public long[] getExtensionId() {
        return this._extensionId;
    }

    public byte[] getExtensionValue() {
        return this._extensionValue;
    }

    public void setCritical(boolean value) {
        this._critical = value;
    }

    public void setExtensionId(long[] value) {
        this._extensionId = value;
    }

    public void setExtensionValue(byte[] value) {
        this._extensionValue = value;
    }

    public Asn1Sequence toAsn1() {
        ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
        list.add(new Asn1ObjectIdentifier(this.getExtensionId()));
        if (this.getCritical()) {
            list.add(new Asn1Boolean(this.getCritical()));
        }
        list.add(new Asn1OctetString(this.getExtensionValue()));
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }

    public X509Extension() {
    }

    public X509Extension(long[] extensionId, byte[] extensionValue) {
        this(extensionId, extensionValue, false);
    }

    public X509Extension(long[] extensionId, byte[] extensionValue, boolean critical) {
        this.setExtensionId(extensionId);
        this.setExtensionValue(extensionValue);
        this.setCritical(critical);
    }
}

