/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.HttpRequestArgs;
import fm.icelink.HttpResponseArgs;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.Log;
import fm.icelink.WebSocket;
import fm.icelink.WebSocketOpenArgs;
import fm.icelink.WebSocketOpenFailureArgs;
import fm.icelink.WebSocketOpenSuccessArgs;
import fm.icelink.WebSocketReceiveArgs;
import fm.icelink.WebSocketRequest;
import fm.icelink.WebSocketSendArgs;
import fm.icelink.WebSocketStreamFailureArgs;
import fm.icelink.WebSocketTransfer;
import java.util.HashMap;

public class WebSocketWebRequestTransfer
extends WebSocketTransfer {
    private WebSocketRequest _activeRequest;
    private WebSocket _webSocket;

    private void connectFailure(WebSocketOpenFailureArgs e) {
        if (super.getOnOpenFailure() != null) {
            super.getOnOpenFailure().invoke(e);
        }
    }

    private void connectSuccess(WebSocketOpenSuccessArgs e) {
        if (super.getOnOpenSuccess() != null) {
            super.getOnOpenSuccess().invoke(e);
        }
    }

    private WebSocket getWebSocket() {
        return this._webSocket;
    }

    @Override
    public void open(HashMap<String, String> headers) {
        this.setWebSocket(new WebSocket(super.getUrl()));
        try {
            WebSocketOpenArgs openArgs = new WebSocketOpenArgs();
            openArgs.setHandshakeTimeout(super.getHandshakeTimeout());
            openArgs.setHeaders(headers);
            openArgs.setOnSuccess((IAction1<WebSocketOpenSuccessArgs>)new IActionDelegate1<WebSocketOpenSuccessArgs>(){

                @Override
                public String getId() {
                    return "fm.icelink.WebSocketWebRequestTransfer.connectSuccess";
                }

                @Override
                public void invoke(WebSocketOpenSuccessArgs e) {
                    WebSocketWebRequestTransfer.this.connectSuccess(e);
                }
            });
            openArgs.setOnFailure((IAction1<WebSocketOpenFailureArgs>)new IActionDelegate1<WebSocketOpenFailureArgs>(){

                @Override
                public String getId() {
                    return "fm.icelink.WebSocketWebRequestTransfer.connectFailure";
                }

                @Override
                public void invoke(WebSocketOpenFailureArgs e) {
                    WebSocketWebRequestTransfer.this.connectFailure(e);
                }
            });
            openArgs.setOnStreamFailure((IAction1<WebSocketStreamFailureArgs>)new IActionDelegate1<WebSocketStreamFailureArgs>(){

                @Override
                public String getId() {
                    return "fm.icelink.WebSocketWebRequestTransfer.streamFailure";
                }

                @Override
                public void invoke(WebSocketStreamFailureArgs e) {
                    WebSocketWebRequestTransfer.this.streamFailure(e);
                }
            });
            openArgs.setOnRequestCreated(super.getOnRequestCreated());
            openArgs.setOnResponseReceived(super.getOnResponseReceived());
            openArgs.setOnReceive((IAction1<WebSocketReceiveArgs>)new IActionDelegate1<WebSocketReceiveArgs>(){

                @Override
                public String getId() {
                    return "fm.icelink.WebSocketWebRequestTransfer.receive";
                }

                @Override
                public void invoke(WebSocketReceiveArgs e) {
                    WebSocketWebRequestTransfer.this.receive(e);
                }
            });
            openArgs.setSender(super.getSender());
            this.getWebSocket().open(openArgs);
        }
        catch (Exception exception) {
            Log.error("Could not open WebSocket.", exception);
        }
    }

    private void receive(WebSocketReceiveArgs e) {
        HttpResponseArgs p = new HttpResponseArgs(this._activeRequest.getArgs());
        p.setTextContent(e.getTextMessage());
        p.setBinaryContent(e.getBinaryMessage());
        this._activeRequest.getCallback().invoke(p);
    }

    @Override
    public HttpResponseArgs send(HttpRequestArgs requestArgs) {
        throw new RuntimeException(new Exception("Synchronous WebSockets are not supported."));
    }

    @Override
    public void sendAsync(HttpRequestArgs requestArgs, IAction1<HttpResponseArgs> callback) {
        try {
            WebSocketRequest request2 = new WebSocketRequest();
            request2.setArgs(requestArgs);
            request2.setCallback(callback);
            WebSocketRequest request = request2;
            WebSocketSendArgs args2 = new WebSocketSendArgs();
            args2.setTimeout(request.getArgs().getTimeout());
            WebSocketSendArgs sendArgs = args2;
            sendArgs.setTextMessage(request.getArgs().getTextContent());
            sendArgs.setBinaryMessage(request.getArgs().getBinaryContent());
            this._activeRequest = request;
            this.getWebSocket().send(sendArgs);
        }
        catch (Exception exception) {
            HttpResponseArgs p = new HttpResponseArgs(requestArgs);
            p.setException(exception);
            p.setStatusCode(0);
            callback.invoke(p);
        }
    }

    private void setWebSocket(WebSocket value) {
        this._webSocket = value;
    }

    @Override
    public void shutdown() {
        this.getWebSocket().close();
    }

    private void streamFailure(WebSocketStreamFailureArgs e) {
        if (super.getOnStreamFailure() != null) {
            super.getOnStreamFailure().invoke(e);
        }
    }

    public WebSocketWebRequestTransfer(String url) {
        super(url);
    }
}

